/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.renderer.tileentity;

import com.github.tartaricacid.touhoulittlemaid.client.model.EntityPlaceholderModel;
import com.github.tartaricacid.touhoulittlemaid.item.ItemEntityPlaceholder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;

public class TileEntityEntityPlaceholderRenderer
extends BlockEntityWithoutLevelRenderer {
    private static final EntityPlaceholderModel BASE_MODEL = new EntityPlaceholderModel();
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"touhou_little_maid", (String)"textures/item/entity_placeholder.png");
    private final Function<ResourceLocation, ModelResourceLocation> recipeToModel = Util.memoize(recipeId -> {
        Path path = Paths.get(recipeId.getPath(), new String[0]);
        String namespace = recipeId.getNamespace();
        ResourceLocation loc = ResourceLocation.fromNamespaceAndPath((String)namespace, (String)"item/%s".formatted(path.getFileName()));
        return ModelResourceLocation.standalone((ResourceLocation)loc);
    });
    private final Function<ResourceLocation, ResourceLocation> recipeToTexture = Util.memoize(recipeId -> {
        Path path = Paths.get(recipeId.getPath(), new String[0]);
        String namespace = recipeId.getNamespace();
        return ResourceLocation.fromNamespaceAndPath((String)namespace, (String)String.format("textures/item/%s.png", path.getFileName().toString()));
    });

    public TileEntityEntityPlaceholderRenderer(BlockEntityRenderDispatcher dispatcher, EntityModelSet modelSet) {
        super(dispatcher, modelSet);
    }

    public void renderByItem(ItemStack stack, ItemDisplayContext transformType, PoseStack poseStack, MultiBufferSource bufferIn, int combinedLight, int combinedOverlay) {
        ResourceLocation recipeId = ItemEntityPlaceholder.getRecipeId(stack);
        BakedModel bakedModel = this.getBakedModel(recipeId);
        poseStack.pushPose();
        if (bakedModel != null) {
            RenderType renderType = Sheets.translucentItemSheet();
            VertexConsumer buffer = bufferIn.getBuffer(renderType);
            Minecraft.getInstance().getItemRenderer().renderModelLists(bakedModel, stack, combinedLight, combinedOverlay, poseStack, buffer);
        } else {
            ResourceLocation texture = this.getTexture(recipeId);
            poseStack.translate(0.5, 1.5, 0.5);
            poseStack.mulPose(Axis.ZN.rotationDegrees(180.0f));
            VertexConsumer buffer = bufferIn.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)texture));
            BASE_MODEL.renderToBuffer(poseStack, buffer, combinedLight, combinedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
        }
        poseStack.popPose();
    }

    @Nullable
    private BakedModel getBakedModel(@Nullable ResourceLocation recipeId) {
        ModelResourceLocation modelId;
        if (recipeId == null) {
            return null;
        }
        ModelManager manager = Minecraft.getInstance().getModelManager();
        BakedModel model = manager.getModel(modelId = this.recipeToModel.apply(recipeId));
        if (model == manager.getMissingModel()) {
            return null;
        }
        return model;
    }

    private ResourceLocation getTexture(@Nullable ResourceLocation recipeId) {
        ResourceLocation texture;
        if (recipeId == null) {
            return TEXTURE;
        }
        ResourceManager manager = Minecraft.getInstance().getResourceManager();
        if (manager.getResource(texture = this.recipeToTexture.apply(recipeId)).isPresent()) {
            return texture;
        }
        return TEXTURE;
    }
}

