/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.sound.data;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.client.sound.OggReader;
import com.github.tartaricacid.touhoulittlemaid.client.sound.data.OpusAudioStream;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitSounds;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.concurrent.CompletableFuture;
import net.minecraft.Util;
import net.minecraft.client.resources.sounds.EntityBoundSoundInstance;
import net.minecraft.client.resources.sounds.Sound;
import net.minecraft.client.sounds.AudioStream;
import net.minecraft.client.sounds.JOrbisAudioStream;
import net.minecraft.client.sounds.SoundBufferLibrary;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;

public class MaidAISoundInstance
extends EntityBoundSoundInstance {
    private final byte[] data;

    public MaidAISoundInstance(EntityMaid maid, byte[] data) {
        super((SoundEvent)InitSounds.MAID_AI_CHAT.get(), SoundSource.NEUTRAL, 1.0f, 1.0f, (Entity)maid, (long)maid.getId());
        this.data = data;
    }

    public CompletableFuture<AudioStream> getStream(SoundBufferLibrary library, Sound sound, boolean looping) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                OggReader.Type oggType = OggReader.getOggType(this.data);
                if (oggType.equals((Object)OggReader.Type.OPUS)) {
                    return new OpusAudioStream(this.data);
                }
                if (oggType.equals((Object)OggReader.Type.VORBIS)) {
                    return new JOrbisAudioStream((InputStream)new ByteArrayInputStream(this.data));
                }
            }
            catch (Exception e) {
                TouhouLittleMaid.LOGGER.error((Object)e);
            }
            return null;
        }, Util.backgroundExecutor());
    }
}

