/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.compat.aquaculture.entity;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.entity.projectile.MaidFishingHook;
import com.teammetallurgy.aquaculture.api.fishing.Hook;
import com.teammetallurgy.aquaculture.api.fishing.Hooks;
import com.teammetallurgy.aquaculture.init.AquaItems;
import com.teammetallurgy.aquaculture.init.AquaLootTables;
import com.teammetallurgy.aquaculture.init.AquaSounds;
import com.teammetallurgy.aquaculture.item.AquaFishingRodItem;
import com.teammetallurgy.aquaculture.item.HookItem;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.entity.IEntityWithComplexSpawn;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.registries.DeferredItem;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class AquacultureFishingHook
extends MaidFishingHook
implements IEntityWithComplexSpawn {
    public static final EntityType<AquacultureFishingHook> TYPE = EntityType.Builder.of(AquacultureFishingHook::new, (MobCategory)MobCategory.MISC).noSave().noSummon().sized(0.25f, 0.25f).clientTrackingRange(4).updateInterval(5).build("aquaculture_fishing_hook");
    private Hook hook = Hooks.EMPTY;
    private ItemStack fishingLine = ItemStack.EMPTY;
    private ItemStack bobber = ItemStack.EMPTY;
    private ItemStack fishingRod = ItemStack.EMPTY;

    public AquacultureFishingHook(EntityType<AquacultureFishingHook> entityType, Level level) {
        super(entityType, level, 0, 0);
    }

    public AquacultureFishingHook(EntityMaid maid, Level world, int luck, int lureSpeed, Vec3 pos, @Nonnull Hook hook, @Nonnull ItemStack fishingLine, @Nonnull ItemStack bobber, @Nonnull ItemStack rod) {
        super(TYPE, world, luck, lureSpeed);
        this.setOwner((Entity)maid);
        this.moveTo(pos);
        this.hook = hook;
        this.fishingLine = fishingLine;
        this.bobber = bobber;
        this.fishingRod = rod;
        if (this.hasHook() && hook.getWeight() != null) {
            this.setDeltaMovement(this.getDeltaMovement().multiply(hook.getWeight()));
        }
    }

    @Override
    protected float getFluidHeight(FluidState fluidState, BlockPos blockPos) {
        if (this.isLavaHook() && fluidState.is(FluidTags.LAVA)) {
            return fluidState.getHeight((BlockGetter)this.level(), blockPos);
        }
        return super.getFluidHeight(fluidState, blockPos);
    }

    @Override
    protected void fallTick(FluidState fluidState) {
        if (this.isLavaHook() && !fluidState.is(FluidTags.LAVA)) {
            this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.03, 0.0));
        } else {
            super.fallTick(fluidState);
        }
    }

    @Override
    protected void spawnFishingParticle(ServerLevel level, BlockState blockState, double x, double y, double z, float sin, float cos) {
        if (this.isLavaHook() && blockState.getFluidState().is(FluidTags.LAVA)) {
            float sinOffset = sin * 0.04f;
            float cosOffset = cos * 0.04f;
            if (this.random.nextFloat() < 0.15f) {
                level.sendParticles((ParticleOptions)ParticleTypes.LAVA, x, y - 0.1, z, 1, (double)sin, 0.1, (double)cos, 0.0);
            }
            level.sendParticles((ParticleOptions)ParticleTypes.SMOKE, x, y, z, 0, (double)cosOffset, 0.01, (double)(-sinOffset), 1.0);
            level.sendParticles((ParticleOptions)ParticleTypes.SMOKE, x, y, z, 0, (double)(-cosOffset), 0.01, (double)sinOffset, 1.0);
        } else {
            super.spawnFishingParticle(level, blockState, x, y, z, sin, cos);
        }
        EntityMaid maidOwner = this.getMaidOwner();
        if (this.hasHook() && this.hook.getCatchSound() != null && maidOwner != null) {
            this.level.playSound(null, maidOwner.blockPosition(), this.hook.getCatchSound(), this.getSoundSource(), 0.1f, 0.1f);
        }
    }

    @Override
    protected void spawnNibbleParticle(ServerLevel level) {
        if (level.getFluidState(this.blockPosition()).is(FluidTags.WATER)) {
            super.spawnNibbleParticle(level);
        } else if (level.getFluidState(this.blockPosition()).is(FluidTags.LAVA)) {
            Vec3 motion = this.getDeltaMovement();
            double boundingBox = this.getBoundingBox().minY + 0.5;
            float bbWidth = this.getBbWidth();
            this.setDeltaMovement(motion.x, -0.4f * Mth.nextFloat((RandomSource)this.random, (float)0.6f, (float)1.0f), motion.z);
            this.playSound((SoundEvent)AquaSounds.BOBBER_LAND_IN_LAVA.get(), 1.0f, 1.0f + (this.random.nextFloat() - this.random.nextFloat()) * 0.4f);
            level.sendParticles((ParticleOptions)ParticleTypes.LAVA, this.getX(), boundingBox, this.getZ(), (int)(1.0f + bbWidth * 20.0f), (double)bbWidth, 0.0, (double)bbWidth, 0.2);
        }
    }

    @Override
    protected void addExtraLoot(List<ItemStack> randomItems) {
        if (randomItems.isEmpty()) {
            if (this.level.dimension() == Level.END) {
                randomItems.add(new ItemStack((ItemLike)AquaItems.FISH_BONES.get()));
            } else if (!this.level.isEmptyBlock(this.blockPosition()) && this.level.getFluidState(this.blockPosition()).isSource()) {
                randomItems.add(new ItemStack((ItemLike)Items.COD));
            }
        }
    }

    @Override
    @NotNull
    protected List<ItemStack> getLoot(MinecraftServer server, LootParams lootParams) {
        List<ItemStack> loot = this.getAquaLoot(server, lootParams);
        if (this.hasHook() && this.hook.getDoubleCatchChance() > 0.0 && this.random.nextDouble() <= this.hook.getDoubleCatchChance()) {
            List<ItemStack> doubleLoot = this.getAquaLoot(server, lootParams);
            loot.addAll(doubleLoot);
        }
        return loot;
    }

    private List<ItemStack> getAquaLoot(MinecraftServer server, LootParams lootParams) {
        ResourceKey lootTableLocation = this.isLavaHook() && this.level.getFluidState(this.blockPosition()).is(FluidTags.LAVA) ? (this.level.dimensionType().hasCeiling() ? AquaLootTables.NETHER_FISHING : AquaLootTables.LAVA_FISHING) : BuiltInLootTables.FISHING;
        LootTable lootTable = server.reloadableRegistries().getLootTable(lootTableLocation);
        return lootTable.getRandomItems(lootParams);
    }

    @Override
    protected void afterFishing() {
        super.afterFishing();
        ItemStackHandler rodHandler = AquaFishingRodItem.getHandler((ItemStack)this.fishingRod);
        ItemStack bait = rodHandler.getStackInSlot(1);
        if (!bait.isEmpty()) {
            bait.hurtAndBreak(1, (ServerLevel)this.level, null, item -> {
                bait.shrink(1);
                this.playSound((SoundEvent)AquaSounds.BOBBER_BAIT_BREAK.get(), 0.7f, 0.2f);
            });
            rodHandler.setStackInSlot(1, bait);
        }
    }

    @Override
    protected void hurtRod(EntityMaid maid, ItemStack rodItem, int rodDamage) {
        int currentDamage = rodItem.getMaxDamage() - rodItem.getDamageValue();
        if (rodDamage >= currentDamage) {
            rodDamage = currentDamage;
        }
        if (this.hook != Hooks.EMPTY && this.hook.getDurabilityChance() > 0.0) {
            if (this.level.random.nextDouble() >= this.hook.getDurabilityChance()) {
                rodItem.hurtAndBreak(rodDamage, (LivingEntity)maid, EquipmentSlot.MAINHAND);
            }
        } else {
            rodItem.hurtAndBreak(rodDamage, (LivingEntity)maid, EquipmentSlot.MAINHAND);
        }
    }

    protected boolean isLavaHook() {
        return this.hasHook() && this.hook.getFluids().contains(FluidTags.LAVA);
    }

    public boolean hasHook() {
        return this.hook != Hooks.EMPTY;
    }

    public Hook getHook() {
        return this.hook;
    }

    @Nonnull
    public ItemStack getBobber() {
        return this.bobber;
    }

    public boolean hasBobber() {
        return !this.getBobber().isEmpty();
    }

    @Nonnull
    public ItemStack getFishingLine() {
        return this.fishingLine;
    }

    public void lavaHurt() {
        if (!this.isLavaHook()) {
            super.lavaHurt();
        }
    }

    public boolean displayFireAnimation() {
        return this.hasHook() && !this.hook.getFluids().contains(FluidTags.LAVA) && super.displayFireAnimation();
    }

    public void writeSpawnData(RegistryFriendlyByteBuf buffer) {
        Entity owner = this.getOwner();
        buffer.writeVarInt(owner == null ? this.getId() : owner.getId());
        buffer.writeUtf(this.hook.getName() == null ? "" : this.hook.getName());
        ItemStack.OPTIONAL_STREAM_CODEC.encode((Object)buffer, (Object)this.fishingLine);
        ItemStack.OPTIONAL_STREAM_CODEC.encode((Object)buffer, (Object)this.bobber);
        ItemStack.OPTIONAL_STREAM_CODEC.encode((Object)buffer, (Object)this.fishingRod);
    }

    public void readSpawnData(RegistryFriendlyByteBuf buffer) {
        Entity owner = this.level.getEntity(buffer.readVarInt());
        this.setOwner(owner);
        String hookName = buffer.readUtf();
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{hookName})) {
            Item hookItem = (Item)((DeferredItem)Hook.HOOKS.get(hookName)).get();
            this.hook = ((HookItem)hookItem).getHookType();
        }
        this.fishingLine = (ItemStack)ItemStack.OPTIONAL_STREAM_CODEC.decode((Object)buffer);
        this.bobber = (ItemStack)ItemStack.OPTIONAL_STREAM_CODEC.decode((Object)buffer);
        this.fishingRod = (ItemStack)ItemStack.OPTIONAL_STREAM_CODEC.decode((Object)buffer);
    }
}

