/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.compat.aquaculture.entity;

import com.github.tartaricacid.touhoulittlemaid.api.entity.fishing.IFishingType;
import com.github.tartaricacid.touhoulittlemaid.compat.aquaculture.entity.AquacultureFishingHook;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.entity.projectile.MaidFishingHook;
import com.teammetallurgy.aquaculture.api.AquacultureAPI;
import com.teammetallurgy.aquaculture.api.fishing.Hook;
import com.teammetallurgy.aquaculture.api.fishing.Hooks;
import com.teammetallurgy.aquaculture.item.AquaFishingRodItem;
import com.teammetallurgy.aquaculture.item.BaitItem;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;

public class AquacultureFishingType
implements IFishingType {
    @Override
    public boolean isFishingRod(ItemStack itemStack) {
        return itemStack.getItem() instanceof AquaFishingRodItem;
    }

    @Override
    public boolean suitableFishingHook(EntityMaid maid, Level worldIn, ItemStack rod, BlockPos blockPos) {
        FluidState fluidState = worldIn.getFluidState(blockPos);
        if (fluidState.is(FluidTags.LAVA)) {
            Hook hook = AquaFishingRodItem.getHookType((ItemStack)rod);
            return hook.getFluids().contains(FluidTags.LAVA);
        }
        return fluidState.is(FluidTags.WATER);
    }

    @Override
    public MaidFishingHook getFishingHook(EntityMaid maid, Level level, ItemStack rod, Vec3 pos) {
        ItemStack bait;
        int lureSpeed = (int)(EnchantmentHelper.getFishingTimeReduction((ServerLevel)((ServerLevel)level), (ItemStack)rod, (Entity)maid) * 20.0f);
        Tiers tier = Tiers.WOOD;
        Item item = rod.getItem();
        if (item instanceof AquaFishingRodItem) {
            AquaFishingRodItem aquaFishingRodItem = (AquaFishingRodItem)item;
            tier = aquaFishingRodItem.getTier();
        }
        if (tier == AquacultureAPI.MATS.NEPTUNIUM) {
            lureSpeed += 100;
        }
        if (!(bait = AquaFishingRodItem.getBait((ItemStack)rod)).isEmpty()) {
            lureSpeed += ((BaitItem)bait.getItem()).getLureSpeedModifier() * 100;
        }
        lureSpeed = Math.min(500, lureSpeed);
        int luck = EnchantmentHelper.getFishingLuckBonus((ServerLevel)((ServerLevel)level), (ItemStack)rod, (Entity)maid);
        Hook hook = AquaFishingRodItem.getHookType((ItemStack)rod);
        if (hook != Hooks.EMPTY && hook.getLuckModifier() > 0) {
            luck += hook.getLuckModifier();
        }
        ItemStack fishingLine = AquaFishingRodItem.getFishingLine((ItemStack)rod);
        ItemStack bobber = AquaFishingRodItem.getBobber((ItemStack)rod);
        return new AquacultureFishingHook(maid, level, luck, lureSpeed, pos, hook, fishingLine, bobber, rod);
    }
}

