/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.compat.gun.tacz.client;

import com.github.tartaricacid.touhoulittlemaid.api.backpack.IMaidBackpack;
import com.github.tartaricacid.touhoulittlemaid.api.entity.IMaid;
import com.github.tartaricacid.touhoulittlemaid.compat.gun.tacz.TacCompat;
import com.github.tartaricacid.touhoulittlemaid.entity.backpack.BackpackManager;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.animated.ILocationModel;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.util.RenderUtils;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.item.GunTabType;
import com.tacz.guns.api.item.IGun;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class GunMaidRender {
    public static void addItemTranslate(PoseStack matrixStack, ItemStack itemStack, boolean isLeft) {
        Item item;
        if (!isLeft && (item = itemStack.getItem()) instanceof IGun) {
            IGun gun = (IGun)item;
            matrixStack.translate(0.0, -0.125, 0.0);
            if (TacCompat.MINIGUN_ID.equals((Object)gun.getGunId(itemStack))) {
                matrixStack.mulPose(Axis.ZP.rotationDegrees(20.0f));
                matrixStack.mulPose(Axis.XP.rotationDegrees(50.0f));
            }
        }
    }

    public static void renderBackGun(PoseStack matrixStack, MultiBufferSource bufferIn, int packedLightIn, ItemStack stack, IMaid maid) {
        EntityMaid entityMaid;
        if (!(stack.getItem() instanceof IGun)) {
            return;
        }
        matrixStack.pushPose();
        matrixStack.mulPose(Axis.ZP.rotationDegrees(180.0f));
        matrixStack.mulPose(Axis.XP.rotationDegrees(180.0f));
        matrixStack.translate(0.0, 0.5, -0.25);
        if (maid instanceof EntityMaid && (entityMaid = (EntityMaid)maid).getConfigManager().isShowBackpack()) {
            maid.getMaidBackpackType().offsetBackpackItem(matrixStack);
        } else {
            BackpackManager.getEmptyBackpack().offsetBackpackItem(matrixStack);
        }
        matrixStack.pushPose();
        matrixStack.mulPose(Axis.XP.rotationDegrees(180.0f));
        matrixStack.mulPose(Axis.ZP.rotationDegrees(-35.0f));
        matrixStack.scale(0.6f, 0.6f, 0.6f);
        Mob mob = maid.asEntity();
        Minecraft.getInstance().getItemRenderer().renderStatic((LivingEntity)mob, stack, ItemDisplayContext.FIXED, false, matrixStack, bufferIn, mob.level(), packedLightIn, OverlayTexture.NO_OVERLAY, mob.getId());
        matrixStack.popPose();
        matrixStack.popPose();
    }

    public static void renderBackGun(ItemStack heldItem, ILocationModel geoModel, IMaid maid, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        EntityMaid entityMaid;
        IGun gun = IGun.getIGunOrNull((ItemStack)heldItem);
        if (gun == null) {
            return;
        }
        Mob entity = maid.asEntity();
        IMaidBackpack maidBackpackType = maid.getMaidBackpackType();
        if (entity instanceof EntityMaid && (entityMaid = (EntityMaid)entity).getConfigManager().isShowBackpack() && maidBackpackType != BackpackManager.getEmptyBackpack()) {
            if (!geoModel.backpackBones().isEmpty()) {
                RenderUtils.prepMatrixForLocator(poseStack, geoModel.backpackBones());
            }
            poseStack.mulPose(Axis.ZP.rotationDegrees(180.0f));
            poseStack.translate(0.0, -1.0, 0.25);
            GunMaidRender.renderBackGun(poseStack, buffer, packedLight, heldItem, maid);
            return;
        }
        TimelessAPI.getCommonGunIndex((ResourceLocation)gun.getGunId(heldItem)).ifPresent(index -> {
            String weaponType = index.getType();
            ItemRenderer renderer = Minecraft.getInstance().getItemRenderer();
            if (GunMaidRender.isPistol(weaponType) && !geoModel.tacPistolBones().isEmpty()) {
                RenderUtils.prepMatrixForLocator(poseStack, geoModel.tacPistolBones());
                poseStack.translate(0.0, -0.125, 0.0);
                poseStack.scale(0.65f, 0.65f, 0.65f);
                poseStack.mulPose(Axis.YP.rotationDegrees(-90.0f));
                poseStack.mulPose(Axis.ZP.rotationDegrees(90.0f));
                renderer.renderStatic(heldItem, ItemDisplayContext.FIXED, packedLight, OverlayTexture.NO_OVERLAY, poseStack, buffer, entity.level(), entity.getId());
            }
            if (!GunMaidRender.isPistol(weaponType) && !geoModel.tacRifleBones().isEmpty()) {
                RenderUtils.prepMatrixForLocator(poseStack, geoModel.tacRifleBones());
                poseStack.scale(0.65f, 0.65f, 0.65f);
                poseStack.mulPose(Axis.YP.rotationDegrees(-180.0f));
                renderer.renderStatic(heldItem, ItemDisplayContext.FIXED, packedLight, OverlayTexture.NO_OVERLAY, poseStack, buffer, entity.level(), entity.getId());
            }
        });
    }

    private static boolean isPistol(String type) {
        return type.equals(GunTabType.PISTOL.name().toLowerCase(Locale.ENGLISH));
    }
}

