/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.compat.sbackpack;

import com.github.tartaricacid.touhoulittlemaid.api.event.InteractMaidEvent;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackItem;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.BackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.IBackpackWrapper;
import net.p3pp3rf1y.sophisticatedcore.init.ModFluids;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeHandler;
import net.p3pp3rf1y.sophisticatedcore.upgrades.tank.TankUpgradeItem;
import net.p3pp3rf1y.sophisticatedcore.upgrades.xppump.XpPumpUpgradeItem;
import net.p3pp3rf1y.sophisticatedcore.util.XpHelper;

public class BackpackRightClickMaidEvent {
    @SubscribeEvent
    public void onClickMaid(InteractMaidEvent event) {
        Player player = event.getPlayer();
        EntityMaid maid = event.getMaid();
        ItemStack stack = event.getStack();
        if (!player.isShiftKeyDown()) {
            return;
        }
        if (!(stack.getItem() instanceof BackpackItem)) {
            return;
        }
        int maidXp = maid.getExperience();
        if (maidXp <= 0) {
            return;
        }
        IBackpackWrapper backpack = BackpackWrapper.fromStack((ItemStack)stack);
        UpgradeHandler handler = backpack.getUpgradeHandler();
        if (!handler.hasUpgrade(XpPumpUpgradeItem.TYPE) || !handler.hasUpgrade(TankUpgradeItem.TYPE)) {
            return;
        }
        backpack.getFluidHandler().ifPresent(fluid -> {
            int count = XpHelper.experienceToLiquid((float)maidXp);
            int filled = fluid.fill(ModFluids.EXPERIENCE_TAG, count, (Fluid)ModFluids.XP_STILL.get(), IFluidHandler.FluidAction.EXECUTE, true);
            if (filled > 0) {
                maid.setExperience(maidXp - (int)XpHelper.liquidToExperience((int)filled));
            }
            event.setCanceled(true);
        });
    }
}

