/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.crafting;

import com.github.tartaricacid.touhoulittlemaid.crafting.AltarRecipe;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import org.jetbrains.annotations.NotNull;

public class AltarRecipeSerializer
implements RecipeSerializer<AltarRecipe> {
    public static final MapCodec<AltarRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(AltarRecipe::getGroup), (App)CraftingBookCategory.CODEC.fieldOf("category").orElse((Object)CraftingBookCategory.MISC).forGetter(AltarRecipe::getCategory), (App)Ingredient.CODEC.listOf().fieldOf("ingredients").flatXmap(AltarRecipeSerializer::checkIngredients, DataResult::success).forGetter(ShapelessRecipe::getIngredients), (App)Codec.FLOAT.fieldOf("power").forGetter(AltarRecipe::getPower), (App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(AltarRecipe::getResult), (App)ResourceLocation.CODEC.fieldOf("entity").forGetter(AltarRecipe::getEntityType), (App)Codec.STRING.optionalFieldOf("lang", (Object)"").forGetter(AltarRecipe::getLangKey)).apply((Applicative)instance, AltarRecipe::new));

    @NotNull
    private static DataResult<NonNullList<Ingredient>> checkIngredients(List<Ingredient> ingredientList) {
        Object[] aingredient = (Ingredient[])ingredientList.toArray(Ingredient[]::new);
        if (aingredient.length == 0) {
            return DataResult.error(() -> "No ingredients for shapeless recipe");
        }
        if (aingredient.length > 6) {
            return DataResult.error(() -> "Too many ingredients for shapeless recipe. The maximum is: 6");
        }
        return DataResult.success((Object)NonNullList.of((Object)Ingredient.EMPTY, (Object[])aingredient));
    }

    private AltarRecipe fromNetwork(RegistryFriendlyByteBuf byteBuf) {
        String group = byteBuf.readUtf();
        CraftingBookCategory category = (CraftingBookCategory)byteBuf.readEnum(CraftingBookCategory.class);
        NonNullList ingredients = NonNullList.withSize((int)byteBuf.readVarInt(), (Object)Ingredient.EMPTY);
        ingredients.replaceAll(ingredient -> (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)byteBuf));
        float power = byteBuf.readFloat();
        ItemStack result = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)byteBuf);
        ResourceLocation entityType = byteBuf.readResourceLocation();
        String langKey = byteBuf.readUtf();
        return new AltarRecipe(group, category, (NonNullList<Ingredient>)ingredients, power, result, entityType, langKey);
    }

    private void toNetwork(RegistryFriendlyByteBuf friendlyByteBuf, AltarRecipe altarRecipe) {
        friendlyByteBuf.writeUtf(altarRecipe.getGroup());
        friendlyByteBuf.writeEnum((Enum)altarRecipe.getCategory());
        friendlyByteBuf.writeVarInt(altarRecipe.getIngredients().size());
        for (Ingredient ingredient : altarRecipe.getIngredients()) {
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)friendlyByteBuf, (Object)ingredient);
        }
        friendlyByteBuf.writeFloat(altarRecipe.getPower());
        ItemStack.STREAM_CODEC.encode((Object)friendlyByteBuf, (Object)altarRecipe.getResult());
        friendlyByteBuf.writeResourceLocation(altarRecipe.getEntityType());
        friendlyByteBuf.writeUtf(altarRecipe.getLangKey());
    }

    public MapCodec<AltarRecipe> codec() {
        return CODEC;
    }

    public StreamCodec<RegistryFriendlyByteBuf, AltarRecipe> streamCodec() {
        return StreamCodec.of(this::toNetwork, this::fromNetwork);
    }
}

