/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.data;

import com.github.tartaricacid.touhoulittlemaid.config.subconfig.AIConfig;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.util.Mth;
import net.neoforged.neoforge.attachment.AttachmentType;

public class ChatTokensAttachment {
    public static final AttachmentType<ChatTokensAttachment> TYPE = AttachmentType.builder(() -> new ChatTokensAttachment(0)).serialize(RecordCodecBuilder.create(ins -> ins.group((App)Codec.INT.fieldOf("num").forGetter(o -> o.num)).apply((Applicative)ins, ChatTokensAttachment::new))).build();
    private int num;

    public ChatTokensAttachment(int num) {
        this.num = num;
    }

    public boolean canAdd() {
        return this.num + 1 <= this.getMaxNum();
    }

    public void add(int num) {
        this.num = num + this.num <= this.getMaxNum() ? (this.num += num) : this.getMaxNum();
    }

    public void min(int num) {
        this.num = num <= this.num ? (this.num -= num) : 0;
    }

    public void set(int num) {
        this.num = Mth.clamp((int)num, (int)0, (int)this.getMaxNum());
    }

    public int getMaxNum() {
        return (Integer)AIConfig.MAX_TOKENS_PER_PLAYER.get();
    }

    public int get() {
        return this.num;
    }
}

