/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.datagen.advancement;

import com.github.tartaricacid.touhoulittlemaid.advancements.altar.AltarCraftTrigger;
import com.github.tartaricacid.touhoulittlemaid.advancements.maid.MaidEventTrigger;
import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import com.github.tartaricacid.touhoulittlemaid.item.ItemEntityPlaceholder;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementType;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.PickedUpItemTrigger;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class MaidBaseAdvancement {
    public static void generate(Consumer<AdvancementHolder> saver, ExistingFileHelper existingFileHelper) {
        AdvancementHolder root = MaidBaseAdvancement.make((ItemLike)Items.FEATHER, "switch_task").addCriterion("maid_event", MaidEventTrigger.create("switch_task")).save(saver, MaidBaseAdvancement.id("maid_base/switch_task"), existingFileHelper);
        MaidBaseAdvancement.generateTask(root, saver, existingFileHelper);
        MaidBaseAdvancement.generateOther(saver, existingFileHelper, root);
        MaidBaseAdvancement.generateBauble(root, saver, existingFileHelper);
        MaidBaseAdvancement.generatePhoto(root, saver, existingFileHelper);
        MaidBaseAdvancement.generateFind(saver, existingFileHelper, root);
        MaidBaseAdvancement.generateReborn(root, saver, existingFileHelper);
    }

    private static void generateFind(Consumer<AdvancementHolder> saver, ExistingFileHelper existingFileHelper, AdvancementHolder root) {
        AdvancementHolder base = MaidBaseAdvancement.make((ItemLike)InitItems.SERVANT_BELL.get(), "use_servant_bell").parent(root).addCriterion("maid_event", MaidEventTrigger.create("use_servant_bell")).save(saver, MaidBaseAdvancement.id("maid_base/use_servant_bell"), existingFileHelper);
        MaidBaseAdvancement.make((ItemLike)InitItems.TRUMPET.get(), "use_trumpet").parent(base).addCriterion("maid_event", MaidEventTrigger.create("use_trumpet")).save(saver, MaidBaseAdvancement.id("maid_base/use_trumpet"), existingFileHelper);
        AdvancementHolder redFoxScroll = MaidBaseAdvancement.make((ItemLike)InitItems.RED_FOX_SCROLL.get(), "use_red_fox_scroll").parent(base).addCriterion("maid_event", MaidEventTrigger.create("use_red_fox_scroll")).save(saver, MaidBaseAdvancement.id("maid_base/use_red_fox_scroll"), existingFileHelper);
        MaidBaseAdvancement.make((ItemLike)InitItems.WHITE_FOX_SCROLL.get(), "use_white_fox_scroll").parent(redFoxScroll).addCriterion("maid_event", MaidEventTrigger.create("use_white_fox_scroll")).save(saver, MaidBaseAdvancement.id("maid_base/use_white_fox_scroll"), existingFileHelper);
    }

    private static void generateOther(Consumer<AdvancementHolder> saver, ExistingFileHelper existingFileHelper, AdvancementHolder root) {
        AdvancementHolder base = MaidBaseAdvancement.make((ItemLike)Items.SADDLE, "pickup_maid").parent(root).addCriterion("maid_event", MaidEventTrigger.create("pickup_maid")).save(saver, MaidBaseAdvancement.id("maid_base/pickup_maid"), existingFileHelper);
        MaidBaseAdvancement.make((ItemLike)Items.EXPERIENCE_BOTTLE, "take_maid_xp").parent(base).addCriterion("maid_event", MaidEventTrigger.create("take_maid_xp")).save(saver, MaidBaseAdvancement.id("maid_base/take_maid_xp"), existingFileHelper);
        MaidBaseAdvancement.make((ItemLike)Items.MILK_BUCKET, "clear_maid_effects").parent(base).addCriterion("maid_event", MaidEventTrigger.create("clear_maid_effects")).save(saver, MaidBaseAdvancement.id("maid_base/clear_maid_effects"), existingFileHelper);
    }

    private static void generateTask(AdvancementHolder root, Consumer<AdvancementHolder> saver, ExistingFileHelper existingFileHelper) {
        AdvancementHolder taskRoot = MaidBaseAdvancement.make((ItemLike)Items.CLOCK, "switch_schedule").parent(root).addCriterion("maid_event", MaidEventTrigger.create("switch_schedule")).save(saver, MaidBaseAdvancement.id("maid_base/switch_schedule"), existingFileHelper);
        AdvancementHolder backpack = MaidBaseAdvancement.make((ItemLike)InitItems.MAID_BACKPACK_BIG.get(), "maid_backpack").parent(taskRoot).addCriterion("maid_event", MaidEventTrigger.create("maid_backpack")).save(saver, MaidBaseAdvancement.id("maid_base/maid_backpack"), existingFileHelper);
        MaidBaseAdvancement.makeGoal((ItemLike)Items.DIAMOND_SWORD, "maid_kill_mob").parent(backpack).addCriterion("maid_event", MaidEventTrigger.create("maid_kill_mob")).save(saver, MaidBaseAdvancement.id("maid_base/maid_kill_mob"), existingFileHelper);
        MaidBaseAdvancement.make((ItemLike)Items.FISHING_ROD, "maid_fishing").parent(backpack).addCriterion("maid_event", MaidEventTrigger.create("maid_fishing")).save(saver, MaidBaseAdvancement.id("maid_base/maid_fishing"), existingFileHelper);
        AdvancementHolder farm = MaidBaseAdvancement.makeGoal((ItemLike)Items.IRON_HOE, "maid_farm").parent(taskRoot).addCriterion("maid_event", MaidEventTrigger.create("maid_farm")).save(saver, MaidBaseAdvancement.id("maid_base/maid_farm"), existingFileHelper);
        AdvancementHolder feedAnimal = MaidBaseAdvancement.make((ItemLike)Items.WHEAT, "maid_feed_animal").parent(farm).addCriterion("maid_event", MaidEventTrigger.create("maid_feed_animal")).save(saver, MaidBaseAdvancement.id("maid_base/maid_feed_animal"), existingFileHelper);
        MaidBaseAdvancement.make((ItemLike)Items.COOKED_BEEF, "maid_feed_player").parent(feedAnimal).addCriterion("maid_event", MaidEventTrigger.create("maid_feed_player")).save(saver, MaidBaseAdvancement.id("maid_base/maid_feed_player"), existingFileHelper);
    }

    private static void generateBauble(AdvancementHolder root, Consumer<AdvancementHolder> saver, ExistingFileHelper existingFileHelper) {
        AdvancementHolder baubleRoot = MaidBaseAdvancement.make((ItemLike)InitItems.FIRE_PROTECT_BAUBLE.get(), "use_protect_bauble").parent(root).addCriterion("maid_event", MaidEventTrigger.create("use_protect_bauble")).save(saver, MaidBaseAdvancement.id("maid_base/use_protect_bauble"), existingFileHelper);
        AdvancementHolder fabric = MaidBaseAdvancement.make((ItemLike)InitItems.NIMBLE_FABRIC.get(), "use_nimble_fabric").parent(baubleRoot).addCriterion("maid_event", MaidEventTrigger.create("use_nimble_fabric")).save(saver, MaidBaseAdvancement.id("maid_base/use_nimble_fabric"), existingFileHelper);
        MaidBaseAdvancement.makeGoal((ItemLike)InitItems.ULTRAMARINE_ORB_ELIXIR.get(), "use_undead_bauble").parent(fabric).addCriterion("maid_event", MaidEventTrigger.create("use_undead_bauble")).save(saver, MaidBaseAdvancement.id("maid_base/use_undead_bauble"), existingFileHelper);
        AdvancementHolder magnet = MaidBaseAdvancement.make((ItemLike)InitItems.ITEM_MAGNET_BAUBLE.get(), "use_item_magnet_bauble").parent(baubleRoot).addCriterion("maid_event", MaidEventTrigger.create("use_item_magnet_bauble")).save(saver, MaidBaseAdvancement.id("maid_base/use_item_magnet_bauble"), existingFileHelper);
        MaidBaseAdvancement.make((ItemLike)InitItems.WIRELESS_IO.get(), "use_wireless_io").parent(magnet).addCriterion("maid_event", MaidEventTrigger.create("use_wireless_io")).save(saver, MaidBaseAdvancement.id("maid_base/use_wireless_io"), existingFileHelper);
    }

    private static void generatePhoto(AdvancementHolder root, Consumer<AdvancementHolder> saver, ExistingFileHelper existingFileHelper) {
        AdvancementHolder photoRoot = MaidBaseAdvancement.make((ItemLike)InitItems.CAMERA.get(), "photo_maid").parent(root).addCriterion("maid_event", MaidEventTrigger.create("photo_maid")).save(saver, MaidBaseAdvancement.id("maid_base/photo_maid"), existingFileHelper);
        AdvancementHolder statue = MaidBaseAdvancement.make((ItemLike)InitItems.CHISEL.get(), "chisel_statue").parent(photoRoot).addCriterion("maid_event", MaidEventTrigger.create("chisel_statue")).save(saver, MaidBaseAdvancement.id("maid_base/chisel_statue"), existingFileHelper);
        MaidBaseAdvancement.make((ItemLike)InitItems.GARAGE_KIT.get(), "pickup_garage_kit").parent(statue).addCriterion("pickup_item", PickedUpItemTrigger.TriggerInstance.thrownItemPickedUpByPlayer(Optional.empty(), Optional.of(ItemPredicate.Builder.item().of(new ItemLike[]{(ItemLike)InitItems.GARAGE_KIT.get()}).build()), Optional.empty())).save(saver, MaidBaseAdvancement.id("maid_base/pickup_garage_kit"), existingFileHelper);
    }

    private static void generateReborn(AdvancementHolder root, Consumer<AdvancementHolder> saver, ExistingFileHelper existingFileHelper) {
        ItemStack stack = ItemEntityPlaceholder.setRecipeId(new ItemStack((ItemLike)InitItems.ENTITY_PLACEHOLDER.get()), "reborn_maid");
        AdvancementHolder rebornRoot = MaidBaseAdvancement.make(stack, "reborn_maid").parent(root).addCriterion("altar_craft", AltarCraftTrigger.Instance.recipe(MaidBaseAdvancement.id("altar_recipe/reborn_maid"))).save(saver, MaidBaseAdvancement.id("maid_base/reborn_maid"), existingFileHelper);
        MaidBaseAdvancement.makeGoal((ItemLike)InitItems.SHRINE.get(), "shrine_reborn_maid").parent(rebornRoot).addCriterion("maid_event", MaidEventTrigger.create("shrine_reborn_maid")).save(saver, MaidBaseAdvancement.id("maid_base/shrine_reborn_maid"), existingFileHelper);
    }

    private static Advancement.Builder make(ItemLike item, String key) {
        MutableComponent title = Component.translatable((String)String.format("advancements.touhou_little_maid.maid_base.%s.title", key));
        MutableComponent desc = Component.translatable((String)String.format("advancements.touhou_little_maid.maid_base.%s.description", key));
        return Advancement.Builder.advancement().display(item, (Component)title, (Component)desc, ResourceLocation.fromNamespaceAndPath((String)"touhou_little_maid", (String)"textures/advancements/backgrounds/stone.png"), AdvancementType.TASK, true, true, false);
    }

    private static Advancement.Builder make(ItemStack item, String key) {
        MutableComponent title = Component.translatable((String)String.format("advancements.touhou_little_maid.maid_base.%s.title", key));
        MutableComponent desc = Component.translatable((String)String.format("advancements.touhou_little_maid.maid_base.%s.description", key));
        return Advancement.Builder.advancement().display(item, (Component)title, (Component)desc, ResourceLocation.fromNamespaceAndPath((String)"touhou_little_maid", (String)"textures/advancements/backgrounds/stone.png"), AdvancementType.TASK, true, true, false);
    }

    private static Advancement.Builder makeGoal(ItemLike item, String key) {
        MutableComponent title = Component.translatable((String)String.format("advancements.touhou_little_maid.maid_base.%s.title", key));
        MutableComponent desc = Component.translatable((String)String.format("advancements.touhou_little_maid.maid_base.%s.description", key));
        return Advancement.Builder.advancement().display(item, (Component)title, (Component)desc, ResourceLocation.fromNamespaceAndPath((String)"touhou_little_maid", (String)"textures/advancements/backgrounds/stone.png"), AdvancementType.GOAL, true, true, false);
    }

    private static ResourceLocation id(String id) {
        return ResourceLocation.fromNamespaceAndPath((String)"touhou_little_maid", (String)id);
    }
}

