/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task;

import com.github.tartaricacid.touhoulittlemaid.advancements.maid.MaidEventTrigger;
import com.github.tartaricacid.touhoulittlemaid.api.task.IFeedTask;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidCheckRateTask;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitTrigger;
import com.google.common.collect.ImmutableMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.Map;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.wrapper.CombinedInvWrapper;

public class MaidFeedOwnerTask
extends MaidCheckRateTask {
    private static final int MAX_DELAY_TIME = 20;
    private final IFeedTask task;
    private final float walkSpeed;
    private final int closeEnoughDist;

    public MaidFeedOwnerTask(IFeedTask task, int closeEnoughDist, float walkSpeed) {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of((Object)MemoryModuleType.WALK_TARGET, (Object)MemoryStatus.VALUE_ABSENT));
        this.task = task;
        this.walkSpeed = walkSpeed;
        this.closeEnoughDist = closeEnoughDist;
        this.setMaxCheckRate(20);
    }

    @Override
    protected boolean checkExtraStartConditions(ServerLevel worldIn, EntityMaid maid) {
        if (super.checkExtraStartConditions(worldIn, maid)) {
            LivingEntity owner = maid.getOwner();
            if (owner instanceof Player && owner.isAlive() && maid.isWithinRestriction(owner.blockPosition())) {
                if (owner.closerThan((Entity)maid, (double)this.closeEnoughDist)) {
                    return true;
                }
                BehaviorUtils.setWalkAndLookTargetMemories((LivingEntity)maid, (Entity)owner, (float)this.walkSpeed, (int)1);
            }
            return false;
        }
        return false;
    }

    protected void start(ServerLevel worldIn, EntityMaid maid, long gameTimeIn) {
        LivingEntity owner = maid.getOwner();
        if (owner instanceof Player) {
            Player player = (Player)owner;
            if (owner.isAlive()) {
                boolean dying = player.getHealth() / player.getMaxHealth() < 0.5f;
                IntArrayList lowestFoods = new IntArrayList();
                IntArrayList lowFoods = new IntArrayList();
                IntArrayList highFoods = new IntArrayList();
                CombinedInvWrapper inv = maid.getAvailableInv(true);
                for (int i = 0; i < inv.getSlots(); ++i) {
                    ItemStack stack = inv.getStackInSlot(i);
                    if (!this.task.isFood(stack, player)) continue;
                    IFeedTask.Priority priority = this.task.getPriority(stack, player);
                    if (priority == IFeedTask.Priority.HIGH) {
                        highFoods.add(i);
                        break;
                    }
                    if (priority == IFeedTask.Priority.LOW) {
                        lowFoods.add(i);
                        break;
                    }
                    if (!dying || priority != IFeedTask.Priority.LOWEST) continue;
                    lowestFoods.add(i);
                    break;
                }
                if (highFoods.isEmpty() && lowFoods.isEmpty() && lowestFoods.isEmpty()) {
                    return;
                }
                IntArrayList map = !highFoods.isEmpty() ? highFoods : (!lowFoods.isEmpty() ? lowFoods : lowestFoods);
                map.intStream().skip(maid.getRandom().nextInt(map.size())).findFirst().ifPresent(slot -> {
                    inv.setStackInSlot(slot, this.task.feed(inv.getStackInSlot(slot), player));
                    maid.swing(InteractionHand.MAIN_HAND);
                    this.setNextCheckTickCount(5);
                    LivingEntity patt0$temp = maid.getOwner();
                    if (patt0$temp instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)patt0$temp;
                        ((MaidEventTrigger)((Object)((Object)InitTrigger.MAID_EVENT.get()))).trigger(serverPlayer, "maid_feed_player");
                    }
                });
            }
        }
    }
}

