/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task;

import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidCheckRateTask;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.util.ItemsUtil;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.items.wrapper.CombinedInvWrapper;

public class MaidMilkTask
extends MaidCheckRateTask {
    private static final int MAX_DELAY_TIME = 40;
    private final float speedModifier;
    private LivingEntity milkTarget = null;

    public MaidMilkTask(float speedModifier) {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of((Object)MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, (Object)MemoryStatus.VALUE_PRESENT, (Object)MemoryModuleType.WALK_TARGET, (Object)MemoryStatus.VALUE_ABSENT));
        this.speedModifier = speedModifier;
        this.setMaxCheckRate(40);
    }

    @Override
    protected boolean checkExtraStartConditions(ServerLevel worldIn, EntityMaid owner) {
        if (super.checkExtraStartConditions(worldIn, owner)) {
            CombinedInvWrapper availableInv = owner.getAvailableInv(true);
            return ItemsUtil.isStackIn((IItemHandler)availableInv, stack -> stack.getItem() == Items.BUCKET) && ItemsUtil.isStackIn((IItemHandler)availableInv, stack -> stack == ItemStack.EMPTY);
        }
        return false;
    }

    protected void start(ServerLevel worldIn, EntityMaid maid, long gameTimeIn) {
        this.milkTarget = null;
        this.getEntities(maid).find(e -> maid.isWithinRestriction(e.blockPosition())).filter(Entity::isAlive).filter(e -> e instanceof Cow).filter(e -> !e.isBaby()).filter(maid::canPathReach).findFirst().ifPresent(e -> {
            this.milkTarget = e;
            BehaviorUtils.setWalkAndLookTargetMemories((LivingEntity)maid, (Entity)e, (float)this.speedModifier, (int)0);
        });
        if (this.milkTarget != null && this.milkTarget.closerThan((Entity)maid, 2.0)) {
            CombinedInvWrapper availableInv = maid.getAvailableInv(false);
            ItemStack bucket = ItemsUtil.getStack((IItemHandler)availableInv, stack -> stack.getItem() == Items.BUCKET);
            if (bucket != ItemStack.EMPTY) {
                bucket.shrink(1);
                ItemHandlerHelper.insertItemStacked((IItemHandler)availableInv, (ItemStack)new ItemStack((ItemLike)Items.MILK_BUCKET), (boolean)false);
            }
            maid.swing(InteractionHand.MAIN_HAND);
            maid.playSound(SoundEvents.COW_MILK, 1.0f, 1.0f);
            this.milkTarget = null;
        }
    }

    private NearestVisibleLivingEntities getEntities(EntityMaid maid) {
        return maid.getBrain().getMemory(MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES).orElse(NearestVisibleLivingEntities.empty());
    }
}

