/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.chatbubble;

import com.github.tartaricacid.touhoulittlemaid.entity.chatbubble.ChatBubbleDataCollection;
import com.github.tartaricacid.touhoulittlemaid.entity.chatbubble.IChatBubbleData;
import com.github.tartaricacid.touhoulittlemaid.entity.chatbubble.RandomEmoji;
import com.github.tartaricacid.touhoulittlemaid.entity.chatbubble.implement.TextChatBubbleData;
import com.github.tartaricacid.touhoulittlemaid.entity.chatbubble.implement.WaitingChatBubbleData;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;

public class ChatBubbleManager {
    private final EntityMaid maid;

    public ChatBubbleManager(EntityMaid maid) {
        this.maid = maid;
    }

    public void tick() {
        RandomEmoji.tick(this.maid);
        if (this.maid.tickCount % 5 != 0) {
            return;
        }
        boolean update = this.getChatBubbleDataCollection().update();
        if (update) {
            this.forceUpdateChatBubble();
        }
    }

    public ChatBubbleDataCollection getChatBubbleDataCollection() {
        return (ChatBubbleDataCollection)this.maid.getEntityData().get(EntityMaid.getChatBubbleKey());
    }

    @Nullable
    public IChatBubbleData getChatBubble(long key) {
        return this.getChatBubbleDataCollection().get(key);
    }

    public void removeChatBubble(long key) {
        this.getChatBubbleDataCollection().remove(key);
        this.forceUpdateChatBubble();
    }

    public void forceUpdateChatBubble() {
        this.maid.getEntityData().set(EntityMaid.getChatBubbleKey(), (Object)this.getChatBubbleDataCollection(), true);
    }

    public long addChatBubble(IChatBubbleData bubble) {
        long key = this.getChatBubbleDataCollection().add(bubble);
        this.forceUpdateChatBubble();
        return key;
    }

    public long addTextChatBubble(String langKey) {
        MutableComponent component = Component.translatable((String)langKey);
        return this.addChatBubble(TextChatBubbleData.type2((Component)component));
    }

    public long addTextChatBubbleIfTimeout(String langKey, long previousChatBubbleId) {
        ChatBubbleDataCollection collection = this.getChatBubbleDataCollection();
        if (previousChatBubbleId < 0L || !collection.containsKey(previousChatBubbleId)) {
            return this.addTextChatBubble(langKey);
        }
        return previousChatBubbleId;
    }

    public long addThinkingText(String langKey) {
        MutableComponent component = Component.translatable((String)langKey).withStyle(ChatFormatting.GRAY).withStyle(ChatFormatting.ITALIC);
        ResourceLocation icon = ResourceLocation.fromNamespaceAndPath((String)"touhou_little_maid", (String)"textures/entity/chat_bubble/yinyang_orb.png");
        return this.addChatBubble(WaitingChatBubbleData.create(600, IChatBubbleData.TYPE_2, 0, (Component)component, icon));
    }

    public void addLLMChatText(String message, long waitingChatBubbleId) {
        MutableComponent component = Component.literal((String)message);
        TextChatBubbleData textChatBubble = TextChatBubbleData.type2((Component)component);
        this.getChatBubbleDataCollection().remove(waitingChatBubbleId);
        this.getChatBubbleDataCollection().add(textChatBubble);
        this.forceUpdateChatBubble();
        LivingEntity livingEntity = this.maid.getOwner();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            Component name = this.maid.getName();
            MutableComponent msg = Component.literal((String)"<").append(name).append(">").append(CommonComponents.SPACE).append(message);
            player.sendSystemMessage((Component)msg.withStyle(ChatFormatting.GRAY));
        }
    }
}

