/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.item;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class EntityExtinguishingAgent
extends Entity {
    public static final EntityType<EntityExtinguishingAgent> TYPE = EntityType.Builder.of(EntityExtinguishingAgent::new, (MobCategory)MobCategory.MISC).sized(0.2f, 0.2f).clientTrackingRange(10).build("extinguishing_agent");
    private static final int MAX_AGE = 60;
    private static final int REMOVE_FIRE_AGE = 5;
    private List<Monster> cacheFireImmuneMonster = Lists.newArrayList();

    public EntityExtinguishingAgent(EntityType<?> entityTypeIn, Level worldIn) {
        super(entityTypeIn, worldIn);
    }

    public EntityExtinguishingAgent(Level worldIn, Vec3 position) {
        this(TYPE, worldIn);
        this.setPos(position.x, position.y, position.z);
    }

    public void baseTick() {
        super.baseTick();
        if (this.tickCount > 60) {
            this.discard();
            return;
        }
        if (this.tickCount == 5) {
            this.removeBlockFire();
            this.removeEntityFire();
        }
        this.damageFireImmuneMonster();
        if (this.level.isClientSide) {
            this.spawnCloudParticle();
        }
        this.playSound(SoundEvents.WOOL_PLACE, 2.0f - 0.03f * (float)this.tickCount, 0.1f);
    }

    private void spawnCloudParticle() {
        int spawnNumber = 4;
        for (int i = 0; i < spawnNumber; ++i) {
            double offsetX = 2.0 * this.random.nextDouble() - 1.0;
            double offsetY = this.random.nextDouble() / 2.0;
            double offsetZ = 2.0 * this.random.nextDouble() - 1.0;
            this.level.addParticle((ParticleOptions)ParticleTypes.CLOUD, false, this.getX() + offsetX, this.getY() + offsetY, this.getZ() + offsetZ, 0.0, 0.1, 0.0);
        }
    }

    private void damageFireImmuneMonster() {
        if (this.tickCount % 5 == 0 && this.cacheFireImmuneMonster != null && !this.cacheFireImmuneMonster.isEmpty()) {
            this.cacheFireImmuneMonster.forEach(monster -> {
                if (monster.isAlive()) {
                    monster.hurt(this.level.damageSources().magic(), 2.0f);
                }
            });
        }
    }

    private void removeEntityFire() {
        List list = this.level.getEntitiesOfClass(LivingEntity.class, this.getBoundingBox().inflate(2.0, 1.0, 2.0));
        this.cacheFireImmuneMonster = this.level.getEntitiesOfClass(Monster.class, this.getBoundingBox().inflate(2.0, 1.0, 2.0), Entity::fireImmune);
        for (LivingEntity entity : list) {
            entity.clearFire();
        }
    }

    private void removeBlockFire() {
        int hRange = 2;
        int vRange = 1;
        for (int x = -hRange; x <= hRange; ++x) {
            for (int y = -vRange; y <= vRange; ++y) {
                for (int z = -hRange; z <= hRange; ++z) {
                    BlockPos pos = this.blockPosition().offset(x, y, z);
                    BlockState state = this.level.getBlockState(pos);
                    if (!state.is(Blocks.FIRE)) continue;
                    this.level.removeBlock(pos, false);
                }
            }
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
    }
}

