/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.monster;

import com.github.tartaricacid.touhoulittlemaid.entity.item.EntityPowerPoint;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.GameRules;

public interface IHasPowerPoint {
    public int getPowerPoint();

    default public void dropPowerPoint(LivingEntity entity) {
        if (!entity.level.getGameRules().getBoolean(GameRules.RULE_DOMOBLOOT)) {
            return;
        }
        int dropTime = 20;
        if (entity.deathTime == dropTime && !entity.level.isClientSide) {
            int powerSplit;
            for (int totalPowerPoint = this.getPowerPoint(); totalPowerPoint > 0; totalPowerPoint -= powerSplit) {
                powerSplit = EntityPowerPoint.getPowerValue(totalPowerPoint);
                EntityPowerPoint powerPoint = new EntityPowerPoint(entity.level, entity.getX(), entity.getY(), entity.getZ(), powerSplit);
                entity.level.addFreshEntity((Entity)powerPoint);
            }
        }
    }
}

