/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.passive;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.PickType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;

public class MaidConfigManager {
    private static final String PICKUP_TAG = "MaidIsPickup";
    private static final String HOME_TAG = "MaidIsHome";
    private static final String RIDEABLE_TAG = "MaidIsRideable";
    private static final String MAID_SUB_CONFIG_TAG = "MaidSubConfig";
    private static final String BACKPACK_SHOW_TAG = "BackpackShow";
    private static final String BACK_ITEM_SHOW_TAG = "BackItemShow";
    private static final String CHATBUBBLE_SHOW_TAG = "ChatBubbleShow";
    private static final String SOUND_FREQ_TAG = "SoundFreq";
    private static final String PICKUP_TYPE_TAG = "PickupType";
    private static final String OPEN_DOOR_TAG = "OpenDoor";
    private static final String OPEN_FENCE_GATE_TAG = "OpenFenceGate";
    private static final String ACTIVE_CLIMBING_TAG = "ActiveClimbing";
    private final SynchedEntityData entityData;

    MaidConfigManager(SynchedEntityData entityData) {
        this.entityData = entityData;
    }

    void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(EntityMaid.DATA_PICKUP, (Object)true);
        builder.define(EntityMaid.DATA_HOME_MODE, (Object)false);
        builder.define(EntityMaid.DATA_RIDEABLE, (Object)true);
        builder.define(EntityMaid.BACKPACK_SHOW, (Object)true);
        builder.define(EntityMaid.BACK_ITEM_SHOW, (Object)true);
        builder.define(EntityMaid.CHATBUBBLE_SHOW, (Object)true);
        builder.define(EntityMaid.SOUND_FREQ, (Object)Float.valueOf(1.0f));
        builder.define(EntityMaid.PICKUP_TYPE, (Object)PickType.ALL.ordinal());
        builder.define(EntityMaid.OPEN_DOOR, (Object)true);
        builder.define(EntityMaid.OPEN_FENCE_GATE, (Object)true);
        builder.define(EntityMaid.ACTIVE_CLIMBING, (Object)true);
    }

    void addAdditionalSaveData(CompoundTag compound) {
        compound.putBoolean(PICKUP_TAG, this.isPickup());
        compound.putBoolean(HOME_TAG, this.isHomeModeEnable());
        compound.putBoolean(RIDEABLE_TAG, this.isRideable());
        CompoundTag maidSubConfig = new CompoundTag();
        maidSubConfig.putBoolean(BACKPACK_SHOW_TAG, this.isShowBackpack());
        maidSubConfig.putBoolean(BACK_ITEM_SHOW_TAG, this.isShowBackItem());
        maidSubConfig.putBoolean(CHATBUBBLE_SHOW_TAG, this.isChatBubbleShow());
        maidSubConfig.putFloat(SOUND_FREQ_TAG, this.getSoundFreq());
        maidSubConfig.putInt(PICKUP_TYPE_TAG, this.getPickupType().ordinal());
        maidSubConfig.putBoolean(OPEN_DOOR_TAG, this.isOpenDoor());
        maidSubConfig.putBoolean(OPEN_FENCE_GATE_TAG, this.isOpenFenceGate());
        maidSubConfig.putBoolean(ACTIVE_CLIMBING_TAG, this.isActiveClimbing());
        compound.put(MAID_SUB_CONFIG_TAG, (Tag)maidSubConfig);
    }

    void readAdditionalSaveData(CompoundTag compound) {
        if (compound.contains(PICKUP_TAG, 1)) {
            this.setPickup(compound.getBoolean(PICKUP_TAG));
        }
        if (compound.contains(HOME_TAG, 1)) {
            this.setHomeModeEnable(compound.getBoolean(HOME_TAG));
        }
        if (compound.contains(RIDEABLE_TAG, 1)) {
            this.setRideable(compound.getBoolean(RIDEABLE_TAG));
        }
        if (compound.contains(MAID_SUB_CONFIG_TAG, 10)) {
            CompoundTag maidSubConfig = compound.getCompound(MAID_SUB_CONFIG_TAG);
            if (maidSubConfig.contains(BACKPACK_SHOW_TAG)) {
                this.setShowBackpack(maidSubConfig.getBoolean(BACKPACK_SHOW_TAG));
            }
            if (maidSubConfig.contains(BACK_ITEM_SHOW_TAG)) {
                this.setShowBackItem(maidSubConfig.getBoolean(BACK_ITEM_SHOW_TAG));
            }
            if (maidSubConfig.contains(CHATBUBBLE_SHOW_TAG)) {
                this.setChatBubbleShow(maidSubConfig.getBoolean(CHATBUBBLE_SHOW_TAG));
            }
            if (maidSubConfig.contains(SOUND_FREQ_TAG)) {
                this.setSoundFreq(maidSubConfig.getFloat(SOUND_FREQ_TAG));
            }
            if (maidSubConfig.contains(PICKUP_TYPE_TAG)) {
                this.setPickupType(PickType.values()[maidSubConfig.getInt(PICKUP_TYPE_TAG)]);
            }
            if (maidSubConfig.contains(OPEN_DOOR_TAG)) {
                this.setOpenDoor(maidSubConfig.getBoolean(OPEN_DOOR_TAG));
            }
            if (maidSubConfig.contains(OPEN_FENCE_GATE_TAG)) {
                this.setOpenFenceGate(maidSubConfig.getBoolean(OPEN_FENCE_GATE_TAG));
            }
            if (maidSubConfig.contains(ACTIVE_CLIMBING_TAG)) {
                this.setActiveClimbing(maidSubConfig.getBoolean(ACTIVE_CLIMBING_TAG));
            }
        }
    }

    boolean isHomeModeEnable() {
        return (Boolean)this.entityData.get(EntityMaid.DATA_HOME_MODE);
    }

    void setHomeModeEnable(boolean enable) {
        this.entityData.set(EntityMaid.DATA_HOME_MODE, (Object)enable);
    }

    boolean isPickup() {
        return (Boolean)this.entityData.get(EntityMaid.DATA_PICKUP);
    }

    void setPickup(boolean isPickup) {
        this.entityData.set(EntityMaid.DATA_PICKUP, (Object)isPickup);
    }

    boolean isRideable() {
        return (Boolean)this.entityData.get(EntityMaid.DATA_RIDEABLE);
    }

    void setRideable(boolean rideable) {
        this.entityData.set(EntityMaid.DATA_RIDEABLE, (Object)rideable);
    }

    public SyncNetwork getSyncNetwork() {
        return new SyncNetwork(this.isShowBackpack(), this.isShowBackItem(), this.isChatBubbleShow(), this.getSoundFreq(), this.getPickupType(), this.isOpenDoor(), this.isOpenFenceGate(), this.isActiveClimbing());
    }

    public boolean isShowBackpack() {
        return (Boolean)this.entityData.get(EntityMaid.BACKPACK_SHOW);
    }

    public void setShowBackpack(boolean show) {
        this.entityData.set(EntityMaid.BACKPACK_SHOW, (Object)show);
    }

    public boolean isShowBackItem() {
        return (Boolean)this.entityData.get(EntityMaid.BACK_ITEM_SHOW);
    }

    public void setShowBackItem(boolean show) {
        this.entityData.set(EntityMaid.BACK_ITEM_SHOW, (Object)show);
    }

    public boolean isChatBubbleShow() {
        return (Boolean)this.entityData.get(EntityMaid.CHATBUBBLE_SHOW);
    }

    public void setChatBubbleShow(boolean show) {
        this.entityData.set(EntityMaid.CHATBUBBLE_SHOW, (Object)show);
    }

    public float getSoundFreq() {
        return ((Float)this.entityData.get(EntityMaid.SOUND_FREQ)).floatValue();
    }

    public void setSoundFreq(float freq) {
        this.entityData.set(EntityMaid.SOUND_FREQ, (Object)Float.valueOf(Mth.clamp((float)freq, (float)0.0f, (float)1.0f)));
    }

    public PickType getPickupType() {
        int index = (Integer)this.entityData.get(EntityMaid.PICKUP_TYPE);
        return PickType.values()[index];
    }

    public void setPickupType(PickType type) {
        this.entityData.set(EntityMaid.PICKUP_TYPE, (Object)type.ordinal());
    }

    public boolean isOpenDoor() {
        return (Boolean)this.entityData.get(EntityMaid.OPEN_DOOR);
    }

    public void setOpenDoor(boolean openDoor) {
        this.entityData.set(EntityMaid.OPEN_DOOR, (Object)openDoor);
    }

    public boolean isOpenFenceGate() {
        return (Boolean)this.entityData.get(EntityMaid.OPEN_FENCE_GATE);
    }

    public void setOpenFenceGate(boolean openFenceGate) {
        this.entityData.set(EntityMaid.OPEN_FENCE_GATE, (Object)openFenceGate);
    }

    public boolean isActiveClimbing() {
        return (Boolean)this.entityData.get(EntityMaid.ACTIVE_CLIMBING);
    }

    public void setActiveClimbing(boolean activeClimbing) {
        this.entityData.set(EntityMaid.ACTIVE_CLIMBING, (Object)activeClimbing);
    }

    public static final class SyncNetwork {
        private boolean showBackpack;
        private boolean showBackItem;
        private boolean showChatBubble;
        private float soundFreq;
        private PickType pickType;
        private boolean openDoor;
        private boolean openFenceGate;
        private boolean activeClimbing;

        public SyncNetwork(boolean showBackpack, boolean showBackItem, boolean showChatBubble, float soundFreq, PickType pickType, boolean openDoor, boolean openFenceGate, boolean activeClimbing) {
            this.showBackpack = showBackpack;
            this.showBackItem = showBackItem;
            this.showChatBubble = showChatBubble;
            this.soundFreq = soundFreq;
            this.pickType = pickType;
            this.openDoor = openDoor;
            this.openFenceGate = openFenceGate;
            this.activeClimbing = activeClimbing;
        }

        public static void encode(SyncNetwork message, FriendlyByteBuf buf) {
            buf.writeBoolean(message.showBackpack);
            buf.writeBoolean(message.showBackItem);
            buf.writeBoolean(message.showChatBubble);
            buf.writeFloat(message.soundFreq);
            buf.writeEnum((Enum)message.pickType);
            buf.writeBoolean(message.openDoor);
            buf.writeBoolean(message.openFenceGate);
            buf.writeBoolean(message.activeClimbing);
        }

        public static SyncNetwork decode(FriendlyByteBuf buf) {
            boolean showBackpack = buf.readBoolean();
            boolean showBackItem = buf.readBoolean();
            boolean showChatBubble = buf.readBoolean();
            float soundFreq = buf.readFloat();
            PickType pickType = (PickType)buf.readEnum(PickType.class);
            boolean openDoor = buf.readBoolean();
            boolean openFenceGate = buf.readBoolean();
            boolean activeClimbing = buf.readBoolean();
            return new SyncNetwork(showBackpack, showBackItem, showChatBubble, soundFreq, pickType, openDoor, openFenceGate, activeClimbing);
        }

        public static void handle(SyncNetwork message, EntityMaid maid) {
            MaidConfigManager configManager = maid.getConfigManager();
            configManager.setShowBackpack(message.showBackpack);
            configManager.setShowBackItem(message.showBackItem);
            configManager.setChatBubbleShow(message.showChatBubble);
            configManager.setSoundFreq(message.soundFreq);
            configManager.setPickupType(message.pickType);
            configManager.setOpenDoor(message.openDoor);
            configManager.setOpenFenceGate(message.openFenceGate);
            configManager.setActiveClimbing(message.activeClimbing);
        }

        public boolean showBackpack() {
            return this.showBackpack;
        }

        public boolean showBackItem() {
            return this.showBackItem;
        }

        public boolean showChatBubble() {
            return this.showChatBubble;
        }

        public float soundFreq() {
            return this.soundFreq;
        }

        public PickType pickType() {
            return this.pickType;
        }

        public boolean openDoor() {
            return this.openDoor;
        }

        public boolean openFenceGate() {
            return this.openFenceGate;
        }

        public boolean activeClimbing() {
            return this.activeClimbing;
        }

        public void setShowBackpack(boolean showBackpack) {
            this.showBackpack = showBackpack;
        }

        public void setShowBackItem(boolean showBackItem) {
            this.showBackItem = showBackItem;
        }

        public void setShowChatBubble(boolean showChatBubble) {
            this.showChatBubble = showChatBubble;
        }

        public void setSoundFreq(float soundFreq) {
            this.soundFreq = Mth.clamp((float)soundFreq, (float)0.0f, (float)1.0f);
        }

        public void setPickType(PickType pickType) {
            this.pickType = pickType;
        }

        public void setOpenDoor(boolean openDoor) {
            this.openDoor = openDoor;
        }

        public void setOpenFenceGate(boolean openFenceGate) {
            this.openFenceGate = openFenceGate;
        }

        public void setActiveClimbing(boolean activeClimbing) {
            this.activeClimbing = activeClimbing;
        }
    }
}

