/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.passive;

import com.github.tartaricacid.touhoulittlemaid.entity.item.EntitySit;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitSounds;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;

public class MaidGameRecordManager {
    private static final String GAME_SKILL_TAG = "MaidGameSkillData";
    private static final String GOMOKU = "Gomoku";
    private static final byte NONE = 0;
    private static final byte WIN = 1;
    private static final byte LOSE = 2;
    private final EntityMaid maid;

    public MaidGameRecordManager(EntityMaid maid) {
        this.maid = maid;
    }

    void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(EntityMaid.GAME_SKILL, (Object)new CompoundTag());
        builder.define(EntityMaid.GAME_STATUE, (Object)0);
    }

    void addAdditionalSaveData(CompoundTag compound) {
        compound.put(GAME_SKILL_TAG, (Tag)this.getGameSkill());
    }

    void readAdditionalSaveData(CompoundTag compound) {
        if (compound.contains(GAME_SKILL_TAG, 10)) {
            this.setGameSkill(compound.getCompound(GAME_SKILL_TAG));
        }
    }

    void tick() {
        if (!(this.maid.getVehicle() instanceof EntitySit) && this.getGameStatue() != 0) {
            this.resetStatue();
        }
    }

    private CompoundTag getGameSkill() {
        return (CompoundTag)this.maid.getEntityData().get(EntityMaid.GAME_SKILL);
    }

    private void setGameSkill(CompoundTag gameSkill) {
        this.maid.getEntityData().set(EntityMaid.GAME_SKILL, (Object)gameSkill, true);
    }

    private byte getGameStatue() {
        return (Byte)this.maid.getEntityData().get(EntityMaid.GAME_STATUE);
    }

    private void setGameStatue(byte gameStatue) {
        this.maid.getEntityData().set(EntityMaid.GAME_STATUE, (Object)gameStatue);
    }

    public int getGomokuWinCount() {
        CompoundTag gameSkill = this.getGameSkill();
        if (gameSkill.contains(GOMOKU, 3)) {
            return gameSkill.getInt(GOMOKU);
        }
        return 0;
    }

    public void increaseGomokuWinCount() {
        CompoundTag gameSkill = this.getGameSkill();
        if (gameSkill.contains(GOMOKU, 3)) {
            gameSkill.putInt(GOMOKU, gameSkill.getInt(GOMOKU) + 1);
        } else {
            gameSkill.putInt(GOMOKU, 1);
        }
        this.setGameSkill(gameSkill);
    }

    public boolean isWin() {
        return this.getGameStatue() == 1;
    }

    public boolean isLost() {
        return this.getGameStatue() == 2;
    }

    public void markStatue(boolean isWin) {
        this.setGameStatue(isWin ? (byte)1 : 2);
        if (isWin) {
            this.maid.playSound((SoundEvent)InitSounds.GAME_WIN.get(), 1.0f, 1.0f);
        } else {
            this.maid.playSound((SoundEvent)InitSounds.GAME_LOST.get(), 1.0f, 1.0f);
        }
    }

    public void resetStatue() {
        this.setGameStatue((byte)0);
    }
}

