/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.passive;

import com.github.tartaricacid.touhoulittlemaid.advancements.maid.MaidEventTrigger;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitTrigger;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.monster.Slime;

public final class MaidKillRecordManager {
    private static final String KILL_RECORD = "KillRecord";
    private static final String TOTAL_COUNT = "TotalCount";
    private static final String SLIME_COUNT = "Slime";
    private static final String WITHER_COUNT = "Wither";
    private static final String ENDER_DRAGON_COUNT = "EnderDragon";
    private int totalCount;
    private int slimeCount;
    private int witherCount;
    private int enderDragonCount;

    void addAdditionalSaveData(CompoundTag compound) {
        CompoundTag killRecord = new CompoundTag();
        killRecord.putInt(KILL_RECORD, this.totalCount);
        killRecord.putInt(SLIME_COUNT, this.slimeCount);
        killRecord.putInt(WITHER_COUNT, this.witherCount);
        killRecord.putInt(ENDER_DRAGON_COUNT, this.enderDragonCount);
        compound.put(KILL_RECORD, (Tag)killRecord);
    }

    void readAdditionalSaveData(CompoundTag compound) {
        if (compound.contains(KILL_RECORD)) {
            CompoundTag killRecord = compound.getCompound(KILL_RECORD);
            this.totalCount = killRecord.getInt(TOTAL_COUNT);
            this.slimeCount = killRecord.getInt(SLIME_COUNT);
            this.witherCount = killRecord.getInt(WITHER_COUNT);
            this.enderDragonCount = killRecord.getInt(ENDER_DRAGON_COUNT);
        }
    }

    public void onTargetDeath(EntityMaid maid, LivingEntity target) {
        LivingEntity owner = maid.getOwner();
        ++this.totalCount;
        this.triggerKill(owner, "maid_kill_mob");
        if (this.totalCount >= 100) {
            this.triggerKill(owner, "kill_100");
        }
        if (target instanceof Slime) {
            ++this.slimeCount;
            if (this.slimeCount >= 300) {
                this.triggerKill(owner, "kill_slime_300");
            }
        }
        if (target instanceof WitherBoss) {
            ++this.witherCount;
            this.triggerKill(owner, "kill_wither");
        }
        if (target instanceof EnderDragon) {
            ++this.enderDragonCount;
            this.triggerKill(owner, "kill_dragon");
        }
    }

    private void triggerKill(@Nullable LivingEntity owner, String eventName) {
        if (owner instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)owner;
            ((MaidEventTrigger)((Object)InitTrigger.MAID_EVENT.get())).trigger(serverPlayer, eventName);
        }
    }
}

