/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.event;

import com.github.tartaricacid.touhoulittlemaid.data.MaidNumAttachment;
import com.github.tartaricacid.touhoulittlemaid.data.PowerAttachment;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.goal.MaidTemptGoal;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitDataAttachment;
import com.github.tartaricacid.touhoulittlemaid.network.message.SyncDataPackage;
import java.util.List;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Creeper;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.network.PacketDistributor;

@EventBusSubscriber
public class EntityJoinWorldEvent {
    @SubscribeEvent
    public static void onCreeperJoinWorld(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Creeper) {
            Creeper creeper = (Creeper)entity;
            creeper.goalSelector.addGoal(1, (Goal)new AvoidEntityGoal((PathfinderMob)creeper, EntityMaid.class, 6.0f, 1.0, 1.2));
        }
    }

    @SubscribeEvent
    public static void onAnimalJoinWorld(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Animal) {
            Animal animal = (Animal)entity;
            List goals = List.copyOf(animal.goalSelector.getAvailableGoals());
            goals.stream().filter(goal -> goal.getGoal() instanceof TemptGoal).findFirst().ifPresent(g -> {
                Goal patt0$temp = g.getGoal();
                if (patt0$temp instanceof TemptGoal) {
                    TemptGoal temptGoal = (TemptGoal)patt0$temp;
                    MaidTemptGoal maidTemptGoal = new MaidTemptGoal(temptGoal.mob, temptGoal.speedModifier, temptGoal.items, temptGoal.canScare);
                    animal.goalSelector.addGoal(g.getPriority(), (Goal)maidTemptGoal);
                }
            });
        }
    }

    @SubscribeEvent
    public static void onPlayerJoinWorld(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            PowerAttachment power = (PowerAttachment)player.getData(InitDataAttachment.POWER_NUM);
            MaidNumAttachment maidNum = (MaidNumAttachment)player.getData(InitDataAttachment.MAID_NUM);
            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new SyncDataPackage(power.get(), maidNum.get()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }
}

