/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.geckolib3.core.molang.builtin;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.molang.binding.ContextBinding;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.molang.builtin.query.BiomeHasAllTags;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.molang.builtin.query.BiomeHasAnyTag;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.molang.builtin.query.EmptyFunction;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.molang.builtin.query.EquippedItemAllTags;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.molang.builtin.query.EquippedItemAnyTags;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.molang.builtin.query.ItemMaxDurability;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.molang.builtin.query.ItemNameAny;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.molang.builtin.query.ItemRemainingDurability;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.molang.builtin.query.Position;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.molang.builtin.query.PositionDelta;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.molang.builtin.query.RelativeBlockHasAllTags;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.molang.builtin.query.RelativeBlockHasAnyTag;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.util.MolangUtils;
import com.github.tartaricacid.touhoulittlemaid.util.EquipmentUtil;
import net.minecraft.client.CameraType;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.phys.Vec3;

public class QueryBinding
extends ContextBinding {
    public static final QueryBinding INSTANCE = new QueryBinding();

    private QueryBinding() {
        this.function("biome_has_all_tags", new BiomeHasAllTags());
        this.function("biome_has_any_tag", new BiomeHasAnyTag());
        this.function("relative_block_has_all_tags", new RelativeBlockHasAllTags());
        this.function("relative_block_has_any_tag", new RelativeBlockHasAnyTag());
        this.function("is_item_name_any", new ItemNameAny());
        this.function("equipped_item_all_tags", new EquippedItemAllTags());
        this.function("equipped_item_any_tag", new EquippedItemAnyTags());
        this.function("position", new Position());
        this.function("position_delta", new PositionDelta());
        this.function("max_durability", new ItemMaxDurability());
        this.function("remaining_durability", new ItemRemainingDurability());
        this.var("actor_count", ctx -> ctx.level().getEntityCount());
        this.var("anim_time", ctx -> ctx.animationControllerContext().animTime());
        this.var("life_time", ctx -> ctx.geoInstance().getSeekTime() / 20.0);
        this.var("head_x_rotation", ctx -> Float.valueOf(ctx.data().netHeadYaw));
        this.var("head_y_rotation", ctx -> Float.valueOf(ctx.data().headPitch));
        this.var("moon_phase", ctx -> ctx.level().getMoonPhase());
        this.var("time_of_day", ctx -> Float.valueOf(MolangUtils.normalizeTime(ctx.level().getDayTime())));
        this.var("time_stamp", ctx -> ctx.level().getDayTime());
        this.entityVar("yaw_speed", ctx -> Float.valueOf(QueryBinding.getYawSpeed((Entity)ctx.entity())));
        this.entityVar("cardinal_facing_2d", ctx -> ((Entity)ctx.entity()).getDirection().get3DDataValue());
        this.entityVar("distance_from_camera", ctx -> ctx.mc().gameRenderer.getMainCamera().getPosition().distanceTo(((Entity)ctx.entity()).position()));
        this.entityVar("eye_target_x_rotation", ctx -> Float.valueOf(((Entity)ctx.entity()).getViewXRot(ctx.animationEvent().getPartialTick())));
        this.entityVar("eye_target_y_rotation", ctx -> Float.valueOf(((Entity)ctx.entity()).getViewYRot(ctx.animationEvent().getPartialTick())));
        this.entityVar("ground_speed", ctx -> Float.valueOf(QueryBinding.getGroundSpeed((Entity)ctx.entity())));
        this.entityVar("modified_distance_moved", ctx -> Float.valueOf(((Entity)ctx.entity()).walkDist));
        this.entityVar("vertical_speed", ctx -> Float.valueOf(QueryBinding.getVerticalSpeed((Entity)ctx.entity())));
        this.entityVar("walk_distance", ctx -> Float.valueOf(((Entity)ctx.entity()).moveDist));
        this.entityVar("has_rider", ctx -> ((Entity)ctx.entity()).isVehicle());
        this.entityVar("is_first_person", ctx -> ctx.mc().options.getCameraType() == CameraType.FIRST_PERSON);
        this.entityVar("is_in_water", ctx -> ((Entity)ctx.entity()).isInWater());
        this.entityVar("is_in_water_or_rain", ctx -> ((Entity)ctx.entity()).isInWaterRainOrBubble());
        this.entityVar("is_on_fire", ctx -> ((Entity)ctx.entity()).isOnFire());
        this.entityVar("is_on_ground", ctx -> ((Entity)ctx.entity()).onGround());
        this.entityVar("is_riding", ctx -> ((Entity)ctx.entity()).isPassenger());
        this.entityVar("is_sneaking", ctx -> ((Entity)ctx.entity()).onGround() && ((Entity)ctx.entity()).getPose() == Pose.CROUCHING);
        this.entityVar("is_spectator", ctx -> ((Entity)ctx.entity()).isSpectator());
        this.entityVar("is_sprinting", ctx -> ((Entity)ctx.entity()).isSprinting());
        this.entityVar("is_swimming", ctx -> ((Entity)ctx.entity()).isSwimming());
        this.livingEntityVar("body_x_rotation", ctx -> Float.valueOf(Mth.lerp((float)ctx.animationEvent().getPartialTick(), (float)((LivingEntity)ctx.entity()).xRotO, (float)((LivingEntity)ctx.entity()).getXRot())));
        this.livingEntityVar("body_y_rotation", ctx -> Float.valueOf(Mth.wrapDegrees((float)Mth.lerp((float)ctx.animationEvent().getPartialTick(), (float)((LivingEntity)ctx.entity()).yBodyRotO, (float)((LivingEntity)ctx.entity()).yBodyRot))));
        this.livingEntityVar("health", ctx -> Float.valueOf(((LivingEntity)ctx.entity()).getHealth()));
        this.livingEntityVar("max_health", ctx -> Float.valueOf(((LivingEntity)ctx.entity()).getMaxHealth()));
        this.livingEntityVar("hurt_time", ctx -> ((LivingEntity)ctx.entity()).hurtTime);
        this.livingEntityVar("is_eating", ctx -> ((LivingEntity)ctx.entity()).getUseItem().getUseAnimation() == UseAnim.EAT);
        this.livingEntityVar("is_playing_dead", ctx -> ((LivingEntity)ctx.entity()).isDeadOrDying());
        this.livingEntityVar("is_sleeping", ctx -> ((LivingEntity)ctx.entity()).isSleeping());
        this.livingEntityVar("is_using_item", ctx -> ((LivingEntity)ctx.entity()).isUsingItem());
        this.livingEntityVar("item_in_use_duration", ctx -> (double)((LivingEntity)ctx.entity()).getTicksUsingItem() / 20.0);
        this.livingEntityVar("item_max_use_duration", ctx -> QueryBinding.getMaxUseDuration((LivingEntity)ctx.entity()) / 20.0);
        this.livingEntityVar("item_remaining_use_duration", ctx -> (double)((LivingEntity)ctx.entity()).getUseItemRemainingTicks() / 20.0);
        this.livingEntityVar("equipment_count", ctx -> QueryBinding.getEquipmentCount((LivingEntity)ctx.entity()));
        this.function("debug_output", new EmptyFunction());
        this.var("has_cape", ctx -> false);
        this.var("cape_flap_amount", ctx -> 0);
        this.maidEntityVar("player_level", ctx -> ((EntityMaid)ctx.entity()).getExperience());
        this.mobEntityVar("is_jumping", ctx -> !((Mob)ctx.entity()).isPassenger() && !((Mob)ctx.entity()).onGround() && !((Mob)ctx.entity()).isInWater());
    }

    private static int getEquipmentCount(LivingEntity entity) {
        int count = 0;
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            ItemStack stack;
            if (!slot.isArmor() || (stack = EquipmentUtil.getEquippedItem(entity, slot)).isEmpty()) continue;
            ++count;
        }
        return count;
    }

    private static double getMaxUseDuration(LivingEntity player) {
        ItemStack useItem = player.getUseItem();
        if (useItem.isEmpty()) {
            return 0.0;
        }
        return useItem.getUseDuration(player);
    }

    private static float getYawSpeed(Entity entity) {
        return 20.0f * (entity.getYRot() - entity.yRotO);
    }

    private static float getGroundSpeed(Entity player) {
        Vec3 velocity = player.getDeltaMovement();
        return 20.0f * Mth.sqrt((float)((float)(velocity.x * velocity.x + velocity.z * velocity.z)));
    }

    private static float getVerticalSpeed(Entity entity) {
        return 20.0f * (float)(entity.position().y - entity.yo);
    }
}

