/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.inventory.container;

import com.github.tartaricacid.touhoulittlemaid.init.InitCapabilities;
import com.github.tartaricacid.touhoulittlemaid.inventory.container.AbstractMaidContainer;
import com.mojang.datafixers.util.Pair;
import javax.annotation.Nonnull;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.SlotItemHandler;

public abstract class MaidMainContainer
extends AbstractMaidContainer {
    protected static final int PLAYER_INVENTORY_SIZE = 36;
    private static final ResourceLocation EMPTY_MAINHAND_SLOT = ResourceLocation.parse((String)"item/empty_slot_sword");
    private static final ResourceLocation EMPTY_BACK_SHOW_SLOT = ResourceLocation.fromNamespaceAndPath((String)"touhou_little_maid", (String)"slot/empty_back_show_slot");
    private static final ResourceLocation[] TEXTURE_EMPTY_SLOTS = new ResourceLocation[]{InventoryMenu.EMPTY_ARMOR_SLOT_BOOTS, InventoryMenu.EMPTY_ARMOR_SLOT_LEGGINGS, InventoryMenu.EMPTY_ARMOR_SLOT_CHESTPLATE, InventoryMenu.EMPTY_ARMOR_SLOT_HELMET};
    private static final EquipmentSlot[] SLOT_IDS = new EquipmentSlot[]{EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET};

    public MaidMainContainer(MenuType<?> type, int id, Inventory inventory, int entityId) {
        super(type, id, inventory, entityId);
        if (this.maid != null) {
            this.addMaidArmorInv();
            this.addMaidHandInv();
            this.addMainDefaultInv();
            this.addBackpackInv(inventory);
        }
    }

    protected void addMaidHandInv() {
        IItemHandler handler = (IItemHandler)this.maid.getCapability(InitCapabilities.HAND_ITEM, Direction.DOWN);
        if (handler == null) {
            return;
        }
        this.addSlot((Slot)new SlotItemHandler(this, handler, 0, 87, 77){

            @OnlyIn(value=Dist.CLIENT)
            public Pair<ResourceLocation, ResourceLocation> getNoItemIcon() {
                return Pair.of((Object)InventoryMenu.BLOCK_ATLAS, (Object)EMPTY_MAINHAND_SLOT);
            }
        });
        this.addSlot((Slot)new SlotItemHandler(this, handler, 1, 121, 77){

            @OnlyIn(value=Dist.CLIENT)
            public Pair<ResourceLocation, ResourceLocation> getNoItemIcon() {
                return Pair.of((Object)InventoryMenu.BLOCK_ATLAS, (Object)InventoryMenu.EMPTY_ARMOR_SLOT_SHIELD);
            }
        });
    }

    protected void addMaidArmorInv() {
        IItemHandler handler = (IItemHandler)this.maid.getCapability(InitCapabilities.ARMOR_ITEM, Direction.DOWN);
        if (handler != null) {
            for (int i = 0; i < 2; ++i) {
                for (int j = 0; j < 2; ++j) {
                    final EquipmentSlot equipmentSlot = SLOT_IDS[2 * i + j];
                    this.addSlot((Slot)new SlotItemHandler(handler, 3 - 2 * i - j, 94 + 20 * j, 37 + 20 * i){

                        public int getMaxStackSize() {
                            return 1;
                        }

                        public boolean mayPlace(@Nonnull ItemStack stack) {
                            return stack.canEquip(equipmentSlot, (LivingEntity)MaidMainContainer.this.maid) && stack.getItem().canFitInsideContainerItems();
                        }

                        public boolean mayPickup(Player playerIn) {
                            ItemStack itemstack = this.getItem();
                            boolean curseEnchant = !itemstack.isEmpty() && !playerIn.isCreative() && EnchantmentHelper.hasTag((ItemStack)itemstack, (TagKey)EnchantmentTags.CURSE);
                            return !curseEnchant && super.mayPickup(playerIn);
                        }

                        @OnlyIn(value=Dist.CLIENT)
                        public Pair<ResourceLocation, ResourceLocation> getNoItemIcon() {
                            return Pair.of((Object)InventoryMenu.BLOCK_ATLAS, (Object)TEXTURE_EMPTY_SLOTS[equipmentSlot.getIndex()]);
                        }
                    });
                }
            }
        }
    }

    protected void addMainDefaultInv() {
        ItemStackHandler inv = this.maid.getMaidInv();
        for (int i = 0; i < 6; ++i) {
            this.addSlot((Slot)new SlotItemHandler((IItemHandler)inv, i, 143 + 18 * i, 37));
            if (i != 5) continue;
            this.addSlot((Slot)new SlotItemHandler(this, (IItemHandler)inv, i, 143 + 18 * i, 37){

                public Pair<ResourceLocation, ResourceLocation> getNoItemIcon() {
                    return Pair.of((Object)InventoryMenu.BLOCK_ATLAS, (Object)EMPTY_BACK_SHOW_SLOT);
                }
            });
        }
    }

    protected abstract void addBackpackInv(Inventory var1);

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack stack1 = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem()) {
            ItemStack stack2 = slot.getItem();
            stack1 = stack2.copy();
            if (index < 36 ? !this.moveItemStackTo(stack2, 36, this.slots.size(), false) : !this.moveItemStackTo(stack2, 0, 36, true)) {
                return ItemStack.EMPTY;
            }
            if (stack2.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (stack2.getCount() == stack1.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, stack2);
            if (36 <= index && index < 40) {
                EquipmentSlot equipmentSlot = SLOT_IDS[index - 36];
                this.maid.setLastArmorItem(equipmentSlot, stack1);
            }
            if (40 <= index && index < 42) {
                int slotIndex = index - 36 - 4;
                EquipmentSlot equipmentSlot = slotIndex == 0 ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND;
                this.maid.setLastHandItem(equipmentSlot, stack1);
            }
        }
        return stack1;
    }
}

