/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.item;

import com.github.tartaricacid.touhoulittlemaid.entity.item.EntityBroom;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class ItemBroom
extends Item {
    public ItemBroom() {
        super(new Item.Properties().stacksTo(1));
    }

    public InteractionResult useOn(UseOnContext context) {
        if (context.getClickedFace() != Direction.DOWN) {
            Level world = context.getLevel();
            BlockPos clickedPos = new BlockPlaceContext(context).getClickedPos();
            AABB boundingBox = EntityBroom.TYPE.getDimensions().makeBoundingBox(Vec3.atBottomCenterOf((Vec3i)clickedPos));
            if (world.noCollision(boundingBox) && world.getEntities(null, boundingBox).isEmpty()) {
                ItemStack stack = context.getItemInHand();
                if (world instanceof ServerLevel) {
                    ServerLevel serverWorld = (ServerLevel)world;
                    EntityBroom broom = (EntityBroom)EntityBroom.TYPE.create(serverWorld, e -> {
                        if (stack.get(DataComponents.CUSTOM_NAME) != null) {
                            e.setCustomName((Component)stack.get(DataComponents.CUSTOM_NAME));
                        }
                    }, context.getClickedPos(), MobSpawnType.SPAWN_EGG, true, true);
                    if (broom == null) {
                        return InteractionResult.FAIL;
                    }
                    if (context.getPlayer() != null) {
                        broom.setOwnerUUID(context.getPlayer().getUUID());
                    }
                    world.addFreshEntity((Entity)broom);
                    world.playSound(null, broom.getX(), broom.getY(), broom.getZ(), SoundEvents.WOOL_PLACE, SoundSource.BLOCKS, 0.75f, 0.8f);
                }
                stack.shrink(1);
                return InteractionResult.sidedSuccess((boolean)world.isClientSide);
            }
        }
        return InteractionResult.FAIL;
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag tooltipFlag) {
        tooltip.add((Component)Component.translatable((String)"tooltips.touhou_little_maid.broom.desc").withStyle(ChatFormatting.GRAY));
    }
}

