/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.item;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitBlocks;
import com.github.tartaricacid.touhoulittlemaid.init.InitDataComponent;
import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import com.github.tartaricacid.touhoulittlemaid.tileentity.TileEntityModelSwitcher;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.block.Block;

public class ItemModelSwitcher
extends BlockItem {
    private static final String NEO_FORGE_DATA_TAG = "NeoForgeData";

    public ItemModelSwitcher() {
        super((Block)InitBlocks.MODEL_SWITCHER.get(), new Item.Properties().stacksTo(1));
    }

    public static ItemStack tileEntityToItemStack(HolderLookup.Provider provider, TileEntityModelSwitcher switcher) {
        ItemStack itemStack = Objects.requireNonNull(((Item)InitItems.MODEL_SWITCHER.get()).getDefaultInstance());
        itemStack.set(InitDataComponent.STORAGE_DATA_TAG, (Object)switcher.saveWithoutMetadata(provider));
        return itemStack;
    }

    public static void itemStackToTileEntity(HolderLookup.Provider provider, ItemStack stack, TileEntityModelSwitcher switcher) {
        CompoundTag tag = (CompoundTag)stack.get(InitDataComponent.STORAGE_DATA_TAG);
        if (tag != null && tag.contains(NEO_FORGE_DATA_TAG, 10)) {
            switcher.loadAdditional(tag, provider);
        }
    }

    public InteractionResult interactLivingEntity(ItemStack stack, Player pPlayer, LivingEntity pInteractionTarget, InteractionHand pUsedHand) {
        if (pInteractionTarget instanceof EntityMaid) {
            EntityMaid maid = (EntityMaid)pInteractionTarget;
            CompoundTag tag = (CompoundTag)stack.getOrDefault(InitDataComponent.STORAGE_DATA_TAG, (Object)new CompoundTag());
            CompoundTag forgeData = tag.contains(NEO_FORGE_DATA_TAG, 10) ? tag.getCompound(NEO_FORGE_DATA_TAG) : new CompoundTag();
            forgeData.put("entity_uuid", (Tag)NbtUtils.createUUID((UUID)maid.getUUID()));
            tag.put(NEO_FORGE_DATA_TAG, (Tag)forgeData);
            stack.set(InitDataComponent.STORAGE_DATA_TAG, (Object)tag);
            return InteractionResult.SUCCESS;
        }
        return super.interactLivingEntity(stack, pPlayer, pInteractionTarget, pUsedHand);
    }

    private boolean hasMaidInfo(ItemStack stack) {
        CompoundTag tag = (CompoundTag)stack.get(InitDataComponent.STORAGE_DATA_TAG);
        if (tag != null && tag.contains(NEO_FORGE_DATA_TAG, 10)) {
            CompoundTag forgeTag = tag.getCompound(NEO_FORGE_DATA_TAG);
            return forgeTag.contains("entity_uuid", 11);
        }
        return false;
    }

    public void appendHoverText(ItemStack pStack, @Nullable Item.TooltipContext pLevel, List<Component> pTooltip, TooltipFlag pFlag) {
        if (this.hasMaidInfo(pStack)) {
            pTooltip.add((Component)Component.translatable((String)"tooltips.touhou_little_maid.model_switcher.bounded").withStyle(ChatFormatting.GRAY));
        } else {
            pTooltip.add((Component)Component.translatable((String)"gui.touhou_little_maid.model_switcher.uuid.empty").withStyle(ChatFormatting.DARK_RED));
        }
    }
}

