/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.item;

import com.github.tartaricacid.touhoulittlemaid.entity.backpack.data.TankBackpackData;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitDataComponent;
import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import com.github.tartaricacid.touhoulittlemaid.item.ItemMaidBackpack;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;

public class ItemTankBackpack
extends ItemMaidBackpack {
    public static ItemStack getTankBackpack(HolderLookup.Provider provider, TankBackpackData data) {
        ItemStack backpack = ((Item)InitItems.TANK_BACKPACK.get()).getDefaultInstance();
        CompoundTag tags = (CompoundTag)backpack.get(InitDataComponent.TANK_BACKPACK_TAG);
        if (tags == null) {
            tags = new CompoundTag();
            backpack.set(InitDataComponent.TANK_BACKPACK_TAG, (Object)tags);
        }
        data.getTank().writeToNBT(provider, tags);
        return backpack;
    }

    public static void setTankBackpack(EntityMaid maid, TankBackpackData data, ItemStack backpack) {
        CompoundTag tags = (CompoundTag)backpack.get(InitDataComponent.TANK_BACKPACK_TAG);
        if (tags == null) {
            tags = new CompoundTag();
            backpack.set(InitDataComponent.TANK_BACKPACK_TAG, (Object)tags);
        }
        data.loadTank(tags, maid);
    }

    public void appendHoverText(ItemStack stack, @Nullable Item.TooltipContext worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        CompoundTag nbt = (CompoundTag)stack.get(InitDataComponent.TANK_BACKPACK_TAG);
        if (nbt != null) {
            CompoundTag compound = nbt.getCompound("Fluid");
            if (compound.isEmpty() || worldIn == null) {
                return;
            }
            HolderLookup.Provider registries = worldIn.registries();
            if (registries == null) {
                return;
            }
            Optional fluid = FluidStack.parse((HolderLookup.Provider)registries, (Tag)compound);
            if (fluid.isEmpty()) {
                return;
            }
            FluidStack fluidStack = (FluidStack)fluid.get();
            MutableComponent fluidInfo = fluidStack.getFluid() == Fluids.EMPTY || fluidStack.getAmount() == 0 ? Component.translatable((String)"tooltips.touhou_little_maid.tank_backpack.empty_fluid").withStyle(ChatFormatting.GRAY) : Component.translatable((String)"tooltips.touhou_little_maid.tank_backpack.fluid", (Object[])new Object[]{fluidStack.getFluid().getFluidType().getDescription(), fluidStack.getAmount()}).withStyle(ChatFormatting.GRAY);
            tooltip.add((Component)fluidInfo);
        }
    }
}

