/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.libs.gagravarr.flac;

import com.github.tartaricacid.touhoulittlemaid.libs.gagravarr.flac.FlacFrame;
import com.github.tartaricacid.touhoulittlemaid.libs.gagravarr.flac.FlacInfo;
import com.github.tartaricacid.touhoulittlemaid.libs.gagravarr.flac.FlacTags;
import com.github.tartaricacid.touhoulittlemaid.libs.gagravarr.flac.FlacUnhandledMetadataBlock;
import com.github.tartaricacid.touhoulittlemaid.libs.gagravarr.ogg.IOUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class FlacMetadataBlock
extends FlacFrame {
    public static final byte STREAMINFO = 0;
    public static final byte PADDING = 1;
    public static final byte APPLICATION = 2;
    public static final byte SEEKTABLE = 3;
    public static final byte VORBIS_COMMENT = 4;
    public static final byte CUESHEET = 5;
    public static final byte PICTURE = 6;
    private byte type;

    public static FlacMetadataBlock create(InputStream inp) throws IOException {
        int typeI = inp.read();
        if (typeI == -1) {
            throw new IllegalArgumentException();
        }
        byte type = IOUtils.fromInt(typeI);
        byte[] l = new byte[3];
        IOUtils.readFully(inp, l);
        int length = (int)IOUtils.getInt3BE(l);
        byte[] data = new byte[length];
        IOUtils.readFully(inp, data);
        switch (type) {
            case 0: {
                return new FlacInfo(data, 0);
            }
            case 4: {
                return new FlacTags.FlacTagsAsMetadata(data);
            }
        }
        return new FlacUnhandledMetadataBlock(type, data);
    }

    protected FlacMetadataBlock(byte type) {
        this.type = type;
    }

    public int getType() {
        return this.type & 0x7F;
    }

    public boolean isLastMetadataBlock() {
        return this.type < 0;
    }

    public byte[] getData() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            baos.write(this.type);
            baos.write(new byte[3]);
            this.write(baos);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        byte[] data = baos.toByteArray();
        IOUtils.putInt3BE(data, 1, data.length);
        return data;
    }

    protected abstract void write(OutputStream var1) throws IOException;
}

