/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.mixin;

import com.github.tartaricacid.touhoulittlemaid.api.mixin.IBlockBurningCacheMixin;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.NodeEvaluator;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={NodeEvaluator.class})
public class NodeEvaluatorBurningCacher {
    @Inject(method={"isBurningBlock"}, at={@At(value="HEAD")}, cancellable=true)
    private static void isBurningBlock(BlockState state, CallbackInfoReturnable<Boolean> cir) {
        IBlockBurningCacheMixin block;
        Block b = state.getBlock();
        if (b instanceof IBlockBurningCacheMixin && (block = (IBlockBurningCacheMixin)b).touhou_little_maid$isBurning() != null) {
            cir.setReturnValue((Object)block.touhou_little_maid$isBurning());
        }
    }

    @Inject(method={"isBurningBlock"}, at={@At(value="RETURN")})
    private static void postIsBurningBlock(BlockState state, CallbackInfoReturnable<Boolean> cir) {
        Block b = state.getBlock();
        if (b instanceof IBlockBurningCacheMixin) {
            IBlockBurningCacheMixin block = (IBlockBurningCacheMixin)b;
            if (block.touhou_little_maid$cannotCache() != null && block.touhou_little_maid$cannotCache().booleanValue()) {
                return;
            }
            Class<?> c = b.getClass();
            if (c != Block.class) {
                try {
                    c.getDeclaredMethod("is", Block.class);
                    block.touhou_little_maid$setCannotCache(true);
                    return;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    try {
                        c.getDeclaredMethod("is", TagKey.class);
                        block.touhou_little_maid$setCannotCache(true);
                        return;
                    }
                    catch (NoSuchMethodException noSuchMethodException2) {
                        try {
                            c.getDeclaredMethod("is", Holder.class);
                            block.touhou_little_maid$setCannotCache(true);
                            return;
                        }
                        catch (NoSuchMethodException noSuchMethodException3) {
                            try {
                                c.getDeclaredMethod("is", HolderSet.class);
                                block.touhou_little_maid$setCannotCache(true);
                                return;
                            }
                            catch (NoSuchMethodException noSuchMethodException4) {
                                // empty catch block
                            }
                        }
                    }
                }
            }
            block.touhou_little_maid$setBurning((Boolean)cir.getReturnValue());
        }
    }
}

