/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.molang.lexer;

import com.github.tartaricacid.touhoulittlemaid.molang.lexer.Cursor;
import com.github.tartaricacid.touhoulittlemaid.molang.lexer.MolangLexerImpl;
import com.github.tartaricacid.touhoulittlemaid.molang.lexer.Token;
import com.github.tartaricacid.touhoulittlemaid.molang.lexer.TokenKind;
import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public interface MolangLexer
extends Closeable {
    @NotNull
    public Cursor cursor();

    @NotNull
    public Token current();

    @NotNull
    public Token next() throws IOException;

    @NotNull
    default public List<Token> tokenizeAll() throws IOException {
        Token token;
        ArrayList<Token> tokens = new ArrayList<Token>();
        while ((token = this.next()).kind() != TokenKind.EOF) {
            tokens.add(token);
        }
        return tokens;
    }

    @Override
    public void close() throws IOException;

    @NotNull
    public static MolangLexer lexer(@NotNull Reader reader) throws IOException {
        return new MolangLexerImpl(reader);
    }

    @NotNull
    public static MolangLexer lexer(@NotNull String string) throws IOException {
        return MolangLexer.lexer(new StringReader(string));
    }

    @NotNull
    public static List<Token> tokenizeAll(@NotNull Reader reader) throws IOException {
        try (MolangLexer lexer = MolangLexer.lexer(reader);){
            List<Token> list = lexer.tokenizeAll();
            return list;
        }
    }

    @NotNull
    public static List<Token> tokenizeAll(@NotNull String string) throws IOException {
        try (MolangLexer lexer = MolangLexer.lexer(string);){
            List<Token> list = lexer.tokenizeAll();
            return list;
        }
    }
}

