/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.network.message;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.item.ItemServantBell;
import com.github.tartaricacid.touhoulittlemaid.util.ResourceLocationUtil;
import io.netty.buffer.ByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record ServantBellSetPackage(int id, String tip) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ServantBellSetPackage> TYPE = new CustomPacketPayload.Type(ResourceLocationUtil.getResourceLocation("servant_bell_set"));
    public static final StreamCodec<ByteBuf, ServantBellSetPackage> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, ServantBellSetPackage::id, (StreamCodec)ByteBufCodecs.STRING_UTF8, ServantBellSetPackage::tip, ServantBellSetPackage::new);

    public static void handle(ServantBellSetPackage message, IPayloadContext context) {
        if (context.flow().isServerbound()) {
            context.enqueueWork(() -> {
                EntityMaid maid;
                ServerPlayer sender = (ServerPlayer)context.player();
                Entity patt0$temp = sender.level.getEntity(message.id);
                if (patt0$temp instanceof EntityMaid && (maid = (EntityMaid)patt0$temp).isOwnedBy((LivingEntity)sender)) {
                    ItemServantBell.recordMaidInfo(sender.getMainHandItem(), maid.getUUID(), message.tip);
                }
            });
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

