/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.tileentity;

import com.github.tartaricacid.touhoulittlemaid.api.block.IBoardGameEntityBlock;
import com.github.tartaricacid.touhoulittlemaid.api.game.gomoku.GomokuCodec;
import com.github.tartaricacid.touhoulittlemaid.api.game.gomoku.Point;
import com.github.tartaricacid.touhoulittlemaid.api.game.gomoku.Statue;
import com.github.tartaricacid.touhoulittlemaid.init.InitBlocks;
import com.github.tartaricacid.touhoulittlemaid.tileentity.TileEntityJoy;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class TileEntityGomoku
extends TileEntityJoy
implements IBoardGameEntityBlock {
    public static final BlockEntityType<TileEntityGomoku> TYPE = BlockEntityType.Builder.of(TileEntityGomoku::new, (Block[])new Block[]{(Block)InitBlocks.GOMOKU.get()}).build(null);
    private static final String CHESS_DATA = "ChessData";
    private static final String STATUE = "Statue";
    private static final String PLAYER_TURN = "PlayerTurn";
    private static final String CHESS_COUNTER = "ChessCounter";
    private static final String LATEST_CHESS_POINT = "LatestChessPoint";
    private byte[][] chessData = new byte[15][15];
    private int statue = Statue.IN_PROGRESS.ordinal();
    private boolean playerTurn = true;
    private int chessCounter = 0;
    private Point latestChessPoint = Point.NULL;

    public TileEntityGomoku(BlockPos pos, BlockState blockState) {
        super(TYPE, pos, blockState);
    }

    @Override
    protected void saveAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        ListTag listTag = new ListTag();
        for (byte[] chessRow : this.chessData) {
            listTag.add((Object)new ByteArrayTag(chessRow));
        }
        this.getPersistentData().put(CHESS_DATA, (Tag)listTag);
        this.getPersistentData().putInt(STATUE, this.statue);
        this.getPersistentData().putBoolean(PLAYER_TURN, this.playerTurn);
        this.getPersistentData().putInt(CHESS_COUNTER, this.chessCounter);
        this.getPersistentData().put(LATEST_CHESS_POINT, (Tag)Point.toTag(this.latestChessPoint));
        super.saveAdditional(pTag, pRegistries);
    }

    @Override
    public void loadAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        super.loadAdditional(pTag, pRegistries);
        ListTag listTag = this.getPersistentData().getList(CHESS_DATA, 7);
        for (int i = 0; i < listTag.size(); ++i) {
            ByteArrayTag byteArray = (ByteArrayTag)listTag.get(i);
            this.chessData[i] = byteArray.getAsByteArray();
        }
        this.statue = this.getPersistentData().getInt(STATUE);
        this.playerTurn = this.getPersistentData().getBoolean(PLAYER_TURN);
        this.chessCounter = this.getPersistentData().getInt(CHESS_COUNTER);
        this.latestChessPoint = Point.fromTag(this.getPersistentData().getCompound(LATEST_CHESS_POINT));
    }

    public void reset() {
        this.chessData = new byte[15][15];
        this.statue = Statue.IN_PROGRESS.ordinal();
        this.playerTurn = true;
        this.chessCounter = 0;
        this.latestChessPoint = Point.NULL;
    }

    public byte[][] getChessData() {
        return this.chessData;
    }

    public void setChessData(List<byte[]> arrayList) {
        for (int i = 0; i < arrayList.size(); ++i) {
            this.chessData[i] = arrayList.get(i);
        }
    }

    public void setChessData(int x, int y, int type) {
        this.chessData[x][y] = (byte)type;
        this.latestChessPoint = new Point(x, y, type);
        ++this.chessCounter;
    }

    public void clickWithDebug() {
        byte[][] drawBoard = new byte[15][15];
        for (int x = 0; x < 15; ++x) {
            boolean blackFirst = x / 2 % 2 == 0;
            for (int y = 0; y < 15; ++y) {
                drawBoard[x][y] = x == 14 && 12 <= y ? 0 : (blackFirst ? (y % 2 == 0 ? 1 : 2) : (y % 2 == 0 ? 2 : 1));
            }
        }
        this.chessData = drawBoard;
        this.latestChessPoint = new Point(14, 10, 2);
        this.chessCounter = 222;
        this.statue = Statue.IN_PROGRESS.ordinal();
        this.playerTurn = true;
    }

    public boolean isPlayerTurn() {
        return this.playerTurn;
    }

    public void setPlayerTurn(boolean playerTurn) {
        this.playerTurn = playerTurn;
    }

    public void setStatue(Statue statue) {
        this.statue = statue.ordinal();
    }

    public Statue getStatue() {
        return Statue.values()[Mth.clamp((int)this.statue, (int)0, (int)(Statue.values().length - 1))];
    }

    public int getChessCounter() {
        return this.chessCounter;
    }

    public Point getLatestChessPoint() {
        return this.latestChessPoint;
    }

    public GomokuCodec.StateData getStateData() {
        return new GomokuCodec.StateData(this.chessData, this.chessCounter, this.latestChessPoint);
    }

    public void setStateData(GomokuCodec.StateData stateData) {
        this.chessData = stateData.board();
        this.chessCounter = stateData.turnCount();
        this.latestChessPoint = stateData.latestPoint();
        this.refresh();
    }
}

