/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.util;

import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public final class PlaceHelper {
    private PlaceHelper() {
    }

    public static boolean notSuitableForPlaceMaid(Level worldIn, BlockPos pos) {
        BlockPos firstPos = pos.above();
        BlockPos secondPos = pos.above(2);
        BlockState firstBlock = worldIn.getBlockState(firstPos);
        BlockState secondBlock = worldIn.getBlockState(secondPos);
        boolean firstBlockHasCollisionBoundingBox = PlaceHelper.hasCollisionBoundingBox(worldIn, firstBlock, firstPos);
        boolean secondBlockHasCollisionBoundingBox = PlaceHelper.hasCollisionBoundingBox(worldIn, secondBlock, secondPos);
        return firstBlockHasCollisionBoundingBox || secondBlockHasCollisionBoundingBox;
    }

    public static boolean notSuitableForPlaceTombstone(Level worldIn, BlockPos pos) {
        BlockState blockState = worldIn.getBlockState(pos);
        return PlaceHelper.hasCollisionBoundingBox(worldIn, blockState, pos) && !blockState.canBeReplaced();
    }

    private static boolean hasCollisionBoundingBox(Level worldIn, BlockState blockState, BlockPos pos) {
        return !blockState.getCollisionShape((BlockGetter)worldIn, pos).isEmpty();
    }
}

