/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.ai.manager.entity;

import com.github.tartaricacid.touhoulittlemaid.ai.manager.entity.HistoryChat;
import com.github.tartaricacid.touhoulittlemaid.ai.manager.entity.MaidAIDataSerializable;
import com.github.tartaricacid.touhoulittlemaid.ai.manager.setting.AvailableSites;
import com.github.tartaricacid.touhoulittlemaid.ai.manager.setting.CharacterSetting;
import com.github.tartaricacid.touhoulittlemaid.ai.manager.setting.SettingReader;
import com.github.tartaricacid.touhoulittlemaid.ai.manager.setting.Site;
import com.github.tartaricacid.touhoulittlemaid.config.subconfig.AIConfig;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.util.CappedQueue;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

public abstract class MaidAIChatData
extends MaidAIDataSerializable {
    protected final EntityMaid maid;
    protected final CappedQueue<HistoryChat> history;

    public MaidAIChatData(EntityMaid maid) {
        this.maid = maid;
        this.history = new CappedQueue((Integer)AIConfig.MAID_MAX_HISTORY_CHAT_SIZE.get());
    }

    @Nullable
    public Site getChatSite() {
        Site site;
        if (StringUtils.isBlank((CharSequence)this.chatSiteName)) {
            site = AvailableSites.getFirstAvailableChatSite();
        } else {
            site = AvailableSites.getChatSite(this.chatSiteName);
            if (site == null) {
                site = AvailableSites.getFirstAvailableChatSite();
            }
        }
        return site;
    }

    @Nullable
    public Site getTtsSite() {
        Site site;
        if (StringUtils.isBlank((CharSequence)this.ttsSiteName)) {
            site = AvailableSites.getFirstAvailableTtsSite();
        } else {
            site = AvailableSites.getTtsSite(this.ttsSiteName);
            if (site == null) {
                site = AvailableSites.getFirstAvailableTtsSite();
            }
        }
        return site;
    }

    @Override
    public String getChatModel() {
        Site site = this.getChatSite();
        String model = "";
        if (site != null && !site.getModels().isEmpty()) {
            model = StringUtils.isBlank((CharSequence)this.chatModel) ? site.getModels().get(0) : this.chatModel;
        }
        return model;
    }

    @Override
    public String getTtsModel() {
        Site site = this.getTtsSite();
        String model = "";
        if (site != null && !site.getModels().isEmpty()) {
            model = StringUtils.isBlank((CharSequence)this.ttsModel) ? site.getModels().get(0) : this.ttsModel;
        }
        return model;
    }

    @Override
    public double getChatTemperature() {
        if (this.chatTemperature >= 0.0) {
            return this.chatTemperature;
        }
        return (Double)AIConfig.CHAT_TEMPERATURE.get();
    }

    @Override
    public String getTtsLanguage() {
        if (StringUtils.isNotBlank((CharSequence)this.ttsLanguage)) {
            return this.ttsLanguage;
        }
        return (String)AIConfig.TTS_LANGUAGE.get();
    }

    public CappedQueue<HistoryChat> getHistory() {
        return this.history;
    }

    public void addUserHistory(String message) {
        this.history.add(HistoryChat.userChat(this.maid, message));
    }

    public void addAssistantHistory(String message) {
        this.history.add(HistoryChat.assistantChat(this.maid, message));
    }

    public EntityMaid getMaid() {
        return this.maid;
    }

    public Optional<CharacterSetting> getSetting() {
        String modelId = this.maid.getModelId();
        return SettingReader.getSetting(modelId);
    }
}

