/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.ai.manager.entity;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.ai.manager.entity.MaidAIChatData;
import com.github.tartaricacid.touhoulittlemaid.ai.manager.response.ResponseChat;
import com.github.tartaricacid.touhoulittlemaid.ai.manager.setting.Site;
import com.github.tartaricacid.touhoulittlemaid.ai.service.Service;
import com.github.tartaricacid.touhoulittlemaid.ai.service.chat.openai.ChatClient;
import com.github.tartaricacid.touhoulittlemaid.ai.service.chat.openai.request.ChatCompletion;
import com.github.tartaricacid.touhoulittlemaid.ai.service.chat.openai.response.ChatCompletionResponse;
import com.github.tartaricacid.touhoulittlemaid.ai.service.tts.TTSApiType;
import com.github.tartaricacid.touhoulittlemaid.ai.service.tts.TTSClient;
import com.github.tartaricacid.touhoulittlemaid.ai.service.tts.TTSRequest;
import com.github.tartaricacid.touhoulittlemaid.config.subconfig.AIConfig;
import com.github.tartaricacid.touhoulittlemaid.entity.chatbubble.ChatBubbleManger;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.network.NetworkHandler;
import com.github.tartaricacid.touhoulittlemaid.network.message.TTSAudioToClientPackage;
import com.github.tartaricacid.touhoulittlemaid.network.message.TTSSystemAudioToClientPackage;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.PacketDistributor;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

public final class MaidAIChatManager
extends MaidAIChatData {
    public MaidAIChatManager(EntityMaid maid) {
        super(maid);
    }

    public void chat(String message, String language) {
        if (((Boolean)AIConfig.CHAT_ENABLED.get()).booleanValue()) {
            @Nullable Site site = this.getChatSite();
            if (site == null || StringUtils.isBlank((CharSequence)site.getApiKey())) {
                ChatBubbleManger.addInnerChatText(this.maid, "ai.touhou_little_maid.chat.api_key.empty");
            } else {
                ChatClient chatClient = Service.getChatClient(site);
                ChatCompletion chatCompletion = Service.getChatCompletion(this, language);
                if (chatCompletion != null) {
                    chatCompletion.userChat(message);
                    chatClient.chat(chatCompletion).handle(this::onShowChatSync, this::onChatFailSync);
                    this.addUserHistory(message);
                } else {
                    ChatBubbleManger.addInnerChatText(this.maid, "ai.touhou_little_maid.chat.no_setting");
                }
            }
        } else {
            ChatBubbleManger.addInnerChatText(this.maid, "ai.touhou_little_maid.chat.disable");
        }
    }

    private void tts(Site site, String chatText, String ttsText) {
        if (TTSApiType.SYSTEM.getName().equals(site.getApiType())) {
            this.onPlaySoundLocal(chatText, ttsText);
        } else {
            TTSClient<?> ttsClient = Service.getTtsClient(site);
            String ttsLang = "en";
            String[] split = this.getTtsLanguage().split("_");
            if (split.length >= 2) {
                ttsLang = split[0];
            }
            TTSRequest ttsRequest = Service.getTtsRequest(site, ttsText, ttsLang, this.getTtsModel());
            ttsClient.request(ttsRequest).handle(data -> this.onPlaySoundSync(chatText, (byte[])data), throwable -> this.onTtsFailSync(chatText, (Throwable)throwable));
        }
    }

    private void onShowChatSync(ChatCompletionResponse result) {
        String rawMessage = result.getFirstChoiceMessage();
        try {
            ResponseChat responseChat = (ResponseChat)Service.GSON.fromJson(rawMessage, ResponseChat.class);
            if (responseChat == null) {
                TouhouLittleMaid.LOGGER.error("Error in Response Chat: {}", (Object)rawMessage);
                this.onChatFailSync((Component)Component.translatable((String)"ai.touhou_little_maid.chat.format.json_format_error", (Object[])new Object[]{rawMessage}));
                return;
            }
            String chatText = responseChat.getChatText();
            String ttsText = responseChat.getTtsText();
            if (StringUtils.isBlank((CharSequence)chatText) || StringUtils.isBlank((CharSequence)ttsText)) {
                TouhouLittleMaid.LOGGER.error("Error in Response Chat: {}", (Object)rawMessage);
                this.onChatFailSync((Component)Component.translatable((String)"ai.touhou_little_maid.chat.format.text_is_empty", (Object[])new Object[]{rawMessage}));
                return;
            }
            this.addAssistantHistory(rawMessage);
            Site site = this.getTtsSite();
            if (((Boolean)AIConfig.TTS_ENABLED.get()).booleanValue() && site != null && StringUtils.isNotBlank((CharSequence)site.getApiKey())) {
                this.tts(site, chatText, ttsText);
            } else {
                ChatBubbleManger.addAiChatTextSync(this.maid, chatText);
            }
        }
        catch (Exception e) {
            TouhouLittleMaid.LOGGER.error(e.getMessage());
        }
    }

    private void onChatFailSync(Throwable throwable) {
        Level level = this.maid.level;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        MinecraftServer server = serverLevel.getServer();
        server.submit(() -> {
            LivingEntity patt0$temp = this.maid.getOwner();
            if (patt0$temp instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)patt0$temp;
                String cause = throwable.getLocalizedMessage();
                player.sendSystemMessage((Component)Component.translatable((String)"ai.touhou_little_maid.chat.connect.fail").append(cause).withStyle(ChatFormatting.RED));
            }
        });
    }

    private void onChatFailSync(Component message) {
        Level level = this.maid.level;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        MinecraftServer server = serverLevel.getServer();
        server.submit(() -> {
            LivingEntity patt0$temp = this.maid.getOwner();
            if (patt0$temp instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)patt0$temp;
                player.sendSystemMessage((Component)Component.translatable((String)"ai.touhou_little_maid.chat.connect.fail").append(message).withStyle(ChatFormatting.RED));
            }
        });
    }

    private void onPlaySoundLocal(String chatText, String ttsText) {
        Level level = this.maid.level;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        MinecraftServer server = serverLevel.getServer();
        server.submit(() -> {
            LivingEntity patt0$temp = this.maid.getOwner();
            if (patt0$temp instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)patt0$temp;
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new TTSSystemAudioToClientPackage(ttsText), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            ChatBubbleManger.addAiChatText(this.maid, chatText);
        });
    }

    private void onPlaySoundSync(String chatText, byte[] data) {
        Level level = this.maid.level;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        MinecraftServer server = serverLevel.getServer();
        server.submit(() -> {
            NetworkHandler.sendToNearby((Entity)this.maid, new TTSAudioToClientPackage(this.maid.getId(), data));
            ChatBubbleManger.addAiChatText(this.maid, chatText);
        });
    }

    private void onTtsFailSync(String chatText, Throwable throwable) {
        Level level = this.maid.level;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        MinecraftServer server = serverLevel.getServer();
        server.submit(() -> {
            ChatBubbleManger.addAiChatText(this.maid, chatText);
            LivingEntity patt0$temp = this.maid.getOwner();
            if (patt0$temp instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)patt0$temp;
                String cause = throwable.getLocalizedMessage();
                player.sendSystemMessage((Component)Component.translatable((String)"ai.touhou_little_maid.tts.connect.fail").append(cause).withStyle(ChatFormatting.RED));
            }
        });
    }
}

