/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.ai.manager.entity;

import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

public class MaidAIDataSerializable {
    public static final StreamCodec<ByteBuf, MaidAIDataSerializable> STREAM_CODEC = new StreamCodec<ByteBuf, MaidAIDataSerializable>(){

        public void encode(ByteBuf buffer, MaidAIDataSerializable message) {
            ByteBufCodecs.STRING_UTF8.encode((Object)buffer, (Object)message.chatSiteName);
            ByteBufCodecs.STRING_UTF8.encode((Object)buffer, (Object)message.chatModel);
            ByteBufCodecs.DOUBLE.encode((Object)buffer, (Object)message.chatTemperature);
            ByteBufCodecs.STRING_UTF8.encode((Object)buffer, (Object)message.ttsSiteName);
            ByteBufCodecs.STRING_UTF8.encode((Object)buffer, (Object)message.ttsModel);
            ByteBufCodecs.STRING_UTF8.encode((Object)buffer, (Object)message.ttsLanguage);
            ByteBufCodecs.STRING_UTF8.encode((Object)buffer, (Object)message.ownerName);
            ByteBufCodecs.STRING_UTF8.encode((Object)buffer, (Object)message.customSetting);
        }

        public MaidAIDataSerializable decode(ByteBuf buffer) {
            String chatSiteName = (String)ByteBufCodecs.STRING_UTF8.decode((Object)buffer);
            String chatModel = (String)ByteBufCodecs.STRING_UTF8.decode((Object)buffer);
            double chatTemperature = (Double)ByteBufCodecs.DOUBLE.decode((Object)buffer);
            String ttsSiteName = (String)ByteBufCodecs.STRING_UTF8.decode((Object)buffer);
            String ttsModel = (String)ByteBufCodecs.STRING_UTF8.decode((Object)buffer);
            String ttsLanguage = (String)ByteBufCodecs.STRING_UTF8.decode((Object)buffer);
            String ownerName = (String)ByteBufCodecs.STRING_UTF8.decode((Object)buffer);
            String customSetting = (String)ByteBufCodecs.STRING_UTF8.decode((Object)buffer);
            return new MaidAIDataSerializable(chatSiteName, chatModel, chatTemperature, ttsSiteName, ttsModel, ttsLanguage, ownerName, customSetting);
        }
    };
    protected String chatSiteName = "";
    protected String chatModel = "";
    protected double chatTemperature = -1.0;
    protected String ttsSiteName = "";
    protected String ttsModel = "";
    protected String ttsLanguage = "";
    protected String ownerName = "";
    protected String customSetting = "";

    public MaidAIDataSerializable() {
    }

    public MaidAIDataSerializable(String chatSiteName, String chatModel, double chatTemperature, String ttsSiteName, String ttsModel, String ttsLanguage, String ownerName, String customSetting) {
        this.chatSiteName = chatSiteName;
        this.chatModel = chatModel;
        this.chatTemperature = chatTemperature;
        this.ttsSiteName = ttsSiteName;
        this.ttsModel = ttsModel;
        this.ttsLanguage = ttsLanguage;
        this.ownerName = ownerName;
        this.customSetting = customSetting;
    }

    public void copyFrom(MaidAIDataSerializable data) {
        this.chatSiteName = data.chatSiteName;
        this.chatModel = data.chatModel;
        this.chatTemperature = data.chatTemperature;
        this.ttsSiteName = data.ttsSiteName;
        this.ttsModel = data.ttsModel;
        this.ttsLanguage = data.ttsLanguage;
        this.ownerName = data.ownerName;
        this.customSetting = data.customSetting;
    }

    public void readFromTag(CompoundTag tag) {
        if (tag.contains("MaidAIChatData")) {
            CompoundTag data = tag.getCompound("MaidAIChatData");
            this.chatSiteName = data.getString("ChatSiteName");
            this.chatModel = data.getString("ChatModel");
            this.chatTemperature = data.getDouble("ChatTemperature");
            this.ttsSiteName = data.getString("TtsSiteName");
            this.ttsModel = data.getString("TtsModel");
            this.ttsLanguage = data.getString("TtsLanguage");
            this.ownerName = data.getString("OwnerName");
            this.customSetting = data.getString("CustomSetting");
        }
    }

    public void writeToTag(CompoundTag tag) {
        CompoundTag data = new CompoundTag();
        data.putString("ChatSiteName", this.chatSiteName);
        data.putString("ChatModel", this.chatModel);
        data.putDouble("ChatTemperature", this.chatTemperature);
        data.putString("TtsSiteName", this.ttsSiteName);
        data.putString("TtsModel", this.ttsModel);
        data.putString("TtsLanguage", this.ttsLanguage);
        data.putString("OwnerName", this.ownerName);
        data.putString("CustomSetting", this.customSetting);
        tag.put("MaidAIChatData", (Tag)data);
    }

    public String getChatSiteName() {
        return this.chatSiteName;
    }

    public void setChatSiteName(String chatSiteName) {
        this.chatSiteName = chatSiteName;
    }

    public String getChatModel() {
        return this.chatModel;
    }

    public void setChatModel(String chatModel) {
        this.chatModel = chatModel;
    }

    public double getChatTemperature() {
        return this.chatTemperature;
    }

    public void setChatTemperature(double chatTemperature) {
        this.chatTemperature = chatTemperature;
    }

    public String getTtsSiteName() {
        return this.ttsSiteName;
    }

    public void setTtsSiteName(String ttsSiteName) {
        this.ttsSiteName = ttsSiteName;
    }

    public String getTtsModel() {
        return this.ttsModel;
    }

    public void setTtsModel(String ttsModel) {
        this.ttsModel = ttsModel;
    }

    public String getTtsLanguage() {
        return this.ttsLanguage;
    }

    public void setTtsLanguage(String ttsLanguage) {
        this.ttsLanguage = ttsLanguage;
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public void setOwnerName(String ownerName) {
        this.ownerName = ownerName;
    }

    public String getCustomSetting() {
        return this.customSetting;
    }

    public void setCustomSetting(String customSetting) {
        this.customSetting = customSetting;
    }
}

