/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.ai.manager.setting;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.ai.manager.setting.Site;
import com.github.tartaricacid.touhoulittlemaid.ai.service.chat.ChatApiType;
import com.github.tartaricacid.touhoulittlemaid.ai.service.tts.TTSApiType;
import com.github.tartaricacid.touhoulittlemaid.util.GetJarResources;
import com.google.common.collect.Maps;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

public class AvailableSites {
    public static final String FILE_NAME = "available_sites.yml";
    private static final Map<String, Site> CHAT_SITES = Maps.newLinkedHashMap();
    private static final Map<String, Site> TTS_SITES = Maps.newLinkedHashMap();
    private static final Map<String, List<String>> CLIENT_CHAT_SITES = Maps.newLinkedHashMap();
    private static final Map<String, List<String>> CLIENT_TTS_SITES = Maps.newLinkedHashMap();
    private static final Path SITES_FILES = Paths.get("config", "touhou_little_maid", "available_sites.yml");
    private static final String JAR_SITES_FILES = String.format("/assets/%s/config/%s", "touhou_little_maid", "available_sites.yml");

    public static void readSites() {
        CHAT_SITES.clear();
        TTS_SITES.clear();
        CLIENT_CHAT_SITES.clear();
        CLIENT_TTS_SITES.clear();
        Yaml yaml = new Yaml();
        LinkedHashMap allSites = Maps.newLinkedHashMap();
        try (InputStream stream = GetJarResources.readTouhouLittleMaidFile(JAR_SITES_FILES);){
            allSites.putAll((Map)yaml.load(stream));
        }
        catch (Exception e) {
            TouhouLittleMaid.LOGGER.error("Failed to read available sites jar file", (Throwable)e);
        }
        if (SITES_FILES.toFile().isFile()) {
            try (FileReader reader = new FileReader(SITES_FILES.toFile(), StandardCharsets.UTF_8);){
                allSites.putAll((Map)yaml.load((Reader)reader));
            }
            catch (Exception e) {
                TouhouLittleMaid.LOGGER.error("Failed to read available sites file", (Throwable)e);
            }
        }
        allSites.forEach((key, value) -> {
            AvailableSites.fixOldVersionConfig(value);
            try {
                Site site = new Site((LinkedHashMap<String, Object>)value);
                if (site.isChat() && StringUtils.isNotBlank((CharSequence)site.getApiKey())) {
                    CHAT_SITES.put((String)key, site);
                    CLIENT_CHAT_SITES.put((String)key, site.getModels());
                }
                if (site.isTts() && StringUtils.isNotBlank((CharSequence)site.getApiKey())) {
                    TTS_SITES.put((String)key, site);
                    CLIENT_TTS_SITES.put((String)key, site.getModels());
                }
            }
            catch (Exception e) {
                TouhouLittleMaid.LOGGER.error("Failed to load site: {}", key, (Object)e);
            }
        });
        AvailableSites.saveSites(allSites);
    }

    public static void saveSites(Map<String, LinkedHashMap<String, Object>> allSites) {
        DumperOptions options = new DumperOptions();
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        Yaml yaml = new Yaml(options);
        try (FileWriter writer = new FileWriter(SITES_FILES.toFile(), StandardCharsets.UTF_8);){
            yaml.dump(allSites, (Writer)writer);
        }
        catch (Exception e) {
            TouhouLittleMaid.LOGGER.error("Failed to save available sites file", (Throwable)e);
        }
    }

    public static Site getChatSite(String key) {
        return CHAT_SITES.get(key);
    }

    public static Site getTtsSite(String key) {
        return TTS_SITES.get(key);
    }

    @Nullable
    public static Site getFirstAvailableChatSite() {
        if (CHAT_SITES.isEmpty()) {
            return null;
        }
        return CHAT_SITES.values().stream().findFirst().orElse(null);
    }

    @Nullable
    public static Site getFirstAvailableTtsSite() {
        if (TTS_SITES.isEmpty()) {
            return null;
        }
        return TTS_SITES.values().stream().findFirst().orElse(null);
    }

    public static Map<String, List<String>> getClientChatSites() {
        return CLIENT_CHAT_SITES;
    }

    public static Map<String, List<String>> getClientTtsSites() {
        return CLIENT_TTS_SITES;
    }

    private static void fixOldVersionConfig(LinkedHashMap<String, Object> map) {
        String type = Objects.requireNonNullElse((String)map.get("type"), "");
        String apiType = Objects.requireNonNullElse((String)map.get("api_type"), "");
        if (apiType.isBlank()) {
            if ("chat".equals(type)) {
                map.put("api_type", ChatApiType.OPENAI.getName());
            }
            if ("tts".equals(type)) {
                map.put("api_type", TTSApiType.FISH_AUDIO.getName());
            }
        }
    }
}

