/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.ai.manager.setting;

import com.github.tartaricacid.touhoulittlemaid.ai.manager.setting.PapiReplacer;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.yaml.snakeyaml.Yaml;

public class CharacterSetting {
    private static final String COMMENTS = "#";
    private static final String META = "meta";
    private static final String SETTING = "setting";
    private static final String AUTHOR = "author";
    private static final String MODEL_ID = "model_id";
    private static final Yaml YAML = new Yaml();
    private final String author;
    private final List<String> modelId;
    private final String rawSetting;

    public CharacterSetting(File settingFile) throws IOException {
        try (FileReader reader = new FileReader(settingFile, StandardCharsets.UTF_8);){
            Map result = (Map)YAML.load((Reader)reader);
            if (result == null) {
                throw new IOException("Failed to load setting file");
            }
            if (!result.containsKey(META) || !result.containsKey(SETTING)) {
                throw new IOException("Setting file must contain meta and setting key");
            }
            Map meta = (Map)result.get(META);
            if (!meta.containsKey(AUTHOR) || !meta.containsKey(MODEL_ID)) {
                throw new IOException("Meta must contain author and model_id key");
            }
            StringBuilder builder = new StringBuilder();
            CharacterSetting.processText((String)result.get(SETTING)).forEach(value -> builder.append((String)value).append("\n"));
            this.author = (String)meta.get(AUTHOR);
            this.modelId = (List)meta.get(MODEL_ID);
            this.rawSetting = builder.toString();
        }
    }

    public CharacterSetting(InputStream stream) throws IOException {
        try (InputStreamReader reader = new InputStreamReader(stream, StandardCharsets.UTF_8);){
            Map result = (Map)YAML.load((Reader)reader);
            if (result == null) {
                throw new IOException("Failed to load setting file");
            }
            if (!result.containsKey(META) || !result.containsKey(SETTING)) {
                throw new IOException("Setting file must contain meta and setting key");
            }
            Map meta = (Map)result.get(META);
            if (!meta.containsKey(AUTHOR) || !meta.containsKey(MODEL_ID)) {
                throw new IOException("Meta must contain author and model_id key");
            }
            StringBuilder builder = new StringBuilder();
            CharacterSetting.processText((String)result.get(SETTING)).forEach(value -> builder.append((String)value).append("\n"));
            this.author = (String)meta.get(AUTHOR);
            this.modelId = (List)meta.get(MODEL_ID);
            this.rawSetting = builder.toString();
        }
    }

    private static List<String> processText(String text) {
        return Arrays.stream(StringUtils.split((String)text, (String)"\n")).map(StringUtils::trim).filter(s -> !s.startsWith(COMMENTS)).filter(StringUtils::isNotEmpty).collect(Collectors.toList());
    }

    public String getSetting(EntityMaid maid, String language) {
        return PapiReplacer.replace(this.rawSetting, maid, language);
    }

    public String getAuthor() {
        return this.author;
    }

    public List<String> getModelId() {
        return this.modelId;
    }
}

