/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.ai.manager.setting;

import com.github.tartaricacid.touhoulittlemaid.ai.manager.response.ResponseChat;
import com.github.tartaricacid.touhoulittlemaid.ai.service.Service;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import java.util.ArrayList;
import java.util.Locale;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.neoforged.neoforge.items.wrapper.RangedWrapper;
import org.apache.commons.lang3.StringUtils;

public class PapiReplacer {
    static String replace(String input, EntityMaid maid, String language) {
        Level level = maid.level;
        return input.replace("${game_time}", PapiReplacer.getTime(level)).replace("${weather}", PapiReplacer.getWeather(level)).replace("${dimension}", PapiReplacer.getDimension(level)).replace("${mainhand_item}", PapiReplacer.getSlotItemName(EquipmentSlot.MAINHAND, maid)).replace("${offhand_item}", PapiReplacer.getSlotItemName(EquipmentSlot.OFFHAND, maid)).replace("${inventory_items}", PapiReplacer.getInventoryItems(maid)).replace("${output_json_format}", PapiReplacer.getOutputJsonFormat()).replace("${chat_language}", language).replace("${tts_language}", PapiReplacer.ttsLanguage(maid.getAiChatManager().getTtsLanguage())).replace("${healthy}", PapiReplacer.getHealthyInfo(maid)).replace("${owner_healthy}", PapiReplacer.getOwnerHealthyInfo(maid)).replace("${armor_items}", PapiReplacer.getArmorItems(maid)).replace("${effects}", PapiReplacer.getEffects(maid)).replace("${biome}", PapiReplacer.getBiome(maid)).replace("${owner_name}", PapiReplacer.getOwnerName(maid)).replace("${custom_setting}", maid.getAiChatManager().getCustomSetting());
    }

    private static String ttsLanguage(String languageTag) {
        String[] parts = ((String)languageTag).split("_");
        if (parts.length == 2) {
            languageTag = parts[0] + "-" + parts[1].toUpperCase(Locale.ENGLISH);
        }
        Locale locale = Locale.forLanguageTag((String)languageTag);
        return locale.getDisplayLanguage() + " (" + locale.getDisplayCountry() + ")";
    }

    private static String getBiome(EntityMaid maid) {
        Biome biome = (Biome)maid.level.getBiome(maid.blockPosition()).value();
        ResourceLocation key = maid.level.registryAccess().registryOrThrow(Registries.BIOME).getKey((Object)biome);
        return key == null ? "\u672a\u77e5 Biome" : key.toString();
    }

    private static String getEffects(EntityMaid maid) {
        ArrayList names = new ArrayList();
        maid.getActiveEffects().forEach(i -> names.add(i.toString()));
        if (names.isEmpty()) {
            return "\u65e0";
        }
        return StringUtils.join(names, (String)", ");
    }

    private static String getArmorItems(EntityMaid maid) {
        ArrayList names = new ArrayList();
        maid.getArmorSlots().forEach(stack -> {
            if (!stack.isEmpty()) {
                String itemName = stack.getDisplayName().getString();
                int count = stack.getCount();
                names.add(String.format("%sx%s", itemName, count));
            }
        });
        if (names.isEmpty()) {
            return "\u7a7a\u7684";
        }
        return StringUtils.join(names, (String)", ");
    }

    private static String getHealthyInfo(EntityMaid maid) {
        float maxHealth = maid.getMaxHealth();
        float health = maid.getHealth();
        return String.format("%s (max %s)", Float.valueOf(health), Float.valueOf(maxHealth));
    }

    private static String getOwnerHealthyInfo(EntityMaid maid) {
        LivingEntity owner = maid.getOwner();
        if (owner != null) {
            float maxHealth = owner.getMaxHealth();
            float health = owner.getHealth();
            return String.format("%s (max %s)", Float.valueOf(health), Float.valueOf(maxHealth));
        }
        return "";
    }

    private static String getOwnerName(EntityMaid maid) {
        String ownerName = maid.getAiChatManager().getOwnerName();
        if (StringUtils.isBlank((CharSequence)ownerName)) {
            return "\u4e3b\u4eba";
        }
        return ownerName;
    }

    private static String getWeather(Level level) {
        if (level.isThundering()) {
            return "\u96f7\u96e8\u5929";
        }
        if (level.isRaining()) {
            return "\u9634\u96e8\u5929";
        }
        return "\u6674\u5929";
    }

    private static String getTime(Level level) {
        long time = level.getDayTime();
        long hours = (time / 1000L + 6L) % 24L;
        long minutes = time % 1000L / 16L;
        return String.format("%02d:%02d", hours, minutes);
    }

    private static String getDimension(Level level) {
        ResourceKey dimension = level.dimension();
        if (dimension == Level.OVERWORLD) {
            return "\u4e3b\u4e16\u754c";
        }
        if (dimension == Level.NETHER) {
            return "\u4e0b\u754c";
        }
        if (dimension == Level.END) {
            return "\u672b\u5730";
        }
        return dimension.location().toString();
    }

    private static String getSlotItemName(EquipmentSlot slot, EntityMaid maid) {
        ItemStack stack = maid.getItemBySlot(slot);
        if (stack.isEmpty()) {
            return "\u7a7a\u7684";
        }
        String itemName = stack.getDisplayName().getString();
        int count = stack.getCount();
        return String.format("%sx%s", itemName, count);
    }

    private static String getInventoryItems(EntityMaid maid) {
        ArrayList<String> names = new ArrayList<String>();
        RangedWrapper backpack = maid.getAvailableBackpackInv();
        for (int i = 0; i < backpack.getSlots(); ++i) {
            ItemStack stack = backpack.getStackInSlot(i);
            if (stack.isEmpty()) continue;
            String itemName = stack.getDisplayName().getString();
            int count = stack.getCount();
            names.add(String.format("%sx%s", itemName, count));
        }
        if (names.isEmpty()) {
            return "\u7a7a\u7684";
        }
        return StringUtils.join(names, (String)", ");
    }

    private static String getOutputJsonFormat() {
        return Service.GSON.toJson((Object)new ResponseChat());
    }
}

