/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.ai.service.chat.openai;

import com.github.tartaricacid.touhoulittlemaid.ai.service.Service;
import com.github.tartaricacid.touhoulittlemaid.ai.service.chat.openai.request.ChatCompletion;
import com.github.tartaricacid.touhoulittlemaid.ai.service.chat.openai.response.ChatCallback;
import com.github.tartaricacid.touhoulittlemaid.ai.service.chat.openai.response.ChatCompletionResponse;
import com.google.common.net.MediaType;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.function.Consumer;

public final class ChatClient {
    private final HttpClient httpClient;
    private String baseUrl = "";
    private String apiKey = "";
    private ChatCompletion chatCompletion;

    public static ChatClient create(HttpClient httpClient) {
        return new ChatClient(httpClient);
    }

    private ChatClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public ChatClient baseUrl(String baseUrl) {
        this.baseUrl = baseUrl.endsWith("/") ? baseUrl.substring(0, baseUrl.length() - 1) : baseUrl;
        return this;
    }

    public ChatClient apiKey(String apiKey) {
        this.apiKey = apiKey;
        return this;
    }

    public ChatClient chat(ChatCompletion chatCompletion) {
        this.chatCompletion = chatCompletion;
        return this;
    }

    public void handle(Consumer<ChatCompletionResponse> consumer, Consumer<Throwable> failConsumer) {
        HttpRequest httpRequest = HttpRequest.newBuilder().header("Content-Type", MediaType.JSON_UTF_8.toString()).header("Authorization", "Bearer " + this.apiKey).POST(HttpRequest.BodyPublishers.ofString(Service.GSON.toJson((Object)this.chatCompletion))).timeout(Duration.ofSeconds(20L)).uri(URI.create(this.baseUrl + ChatCompletion.getUrl())).build();
        this.httpClient.sendAsync(httpRequest, HttpResponse.BodyHandlers.ofString()).whenComplete((response, throwable) -> {
            ChatCallback callback = new ChatCallback(consumer);
            if (throwable != null) {
                callback.onFailure(httpRequest, (Throwable)throwable);
                failConsumer.accept((Throwable)throwable);
            } else {
                callback.onResponse((HttpResponse<String>)response, failConsumer);
            }
        });
    }
}

