/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.ai.service.tts.fishaudio;

import com.github.tartaricacid.touhoulittlemaid.ai.service.Service;
import com.github.tartaricacid.touhoulittlemaid.ai.service.tts.TTSClient;
import com.github.tartaricacid.touhoulittlemaid.ai.service.tts.fishaudio.request.TTSFishAudioRequest;
import com.github.tartaricacid.touhoulittlemaid.ai.service.tts.fishaudio.response.TTSFishAudioCallback;
import com.google.common.net.MediaType;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.function.Consumer;

public class TTSFishAudioClient
implements TTSClient<TTSFishAudioRequest> {
    private final HttpClient httpClient;
    private String baseUrl = "";
    private String apiKey = "";
    private TTSFishAudioRequest request;

    public static TTSFishAudioClient create(HttpClient httpClient) {
        return new TTSFishAudioClient(httpClient);
    }

    private TTSFishAudioClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public TTSFishAudioClient baseUrl(String baseUrl) {
        this.baseUrl = baseUrl.endsWith("/") ? baseUrl.substring(0, baseUrl.length() - 1) : baseUrl;
        return this;
    }

    public TTSFishAudioClient apiKey(String apiKey) {
        this.apiKey = apiKey;
        return this;
    }

    public TTSFishAudioClient request(TTSFishAudioRequest request) {
        this.request = request;
        return this;
    }

    @Override
    public void handle(Consumer<byte[]> consumer, Consumer<Throwable> failConsumer) {
        HttpRequest httpRequest = HttpRequest.newBuilder().header("Content-Type", MediaType.JSON_UTF_8.toString()).header("Authorization", "Bearer " + this.apiKey).POST(HttpRequest.BodyPublishers.ofString(Service.GSON.toJson((Object)this.request))).timeout(Duration.ofSeconds(20L)).uri(URI.create(this.baseUrl + TTSFishAudioRequest.getUrl())).build();
        this.httpClient.sendAsync(httpRequest, HttpResponse.BodyHandlers.ofByteArray()).whenComplete((response, throwable) -> {
            TTSFishAudioCallback callback = new TTSFishAudioCallback(consumer);
            if (throwable != null) {
                callback.onFailure(httpRequest, (Throwable)throwable);
                failConsumer.accept((Throwable)throwable);
            } else {
                callback.onResponse((HttpResponse<byte[]>)response, failConsumer);
            }
        });
    }
}

