/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.block;

import com.github.tartaricacid.touhoulittlemaid.advancements.altar.AltarCraftTrigger;
import com.github.tartaricacid.touhoulittlemaid.api.bauble.IMaidBauble;
import com.github.tartaricacid.touhoulittlemaid.crafting.AltarRecipe;
import com.github.tartaricacid.touhoulittlemaid.data.PowerAttachment;
import com.github.tartaricacid.touhoulittlemaid.init.InitDataAttachment;
import com.github.tartaricacid.touhoulittlemaid.init.InitRecipes;
import com.github.tartaricacid.touhoulittlemaid.init.InitSounds;
import com.github.tartaricacid.touhoulittlemaid.init.InitTrigger;
import com.github.tartaricacid.touhoulittlemaid.tileentity.TileEntityAltar;
import com.github.tartaricacid.touhoulittlemaid.util.PosListData;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.particle.TerrainParticle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.client.extensions.common.IClientBlockExtensions;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;

public class BlockAltar
extends Block
implements EntityBlock {
    public static final IClientBlockExtensions CLIENT_BLOCK_EXTENSIONS = FMLEnvironment.dist == Dist.CLIENT ? new IClientBlockExtensions(){

        public boolean addHitEffects(BlockState state, Level world, HitResult target, ParticleEngine manager) {
            if (target instanceof BlockHitResult) {
                BlockHitResult blockTarget = (BlockHitResult)target;
                if (world instanceof ClientLevel) {
                    ClientLevel clientLevel = (ClientLevel)world;
                    BlockPos pos = blockTarget.getBlockPos();
                    this.getAltar((BlockGetter)world, pos).ifPresent(altar -> this.crack(clientLevel, pos, altar.getStorageState(), blockTarget.getDirection()));
                }
            }
            return true;
        }

        public boolean addDestroyEffects(BlockState state, Level world, BlockPos pos, ParticleEngine manager) {
            this.getAltar((BlockGetter)world, pos).ifPresent(altar -> Minecraft.getInstance().particleEngine.destroy(pos, altar.getStorageState()));
            return true;
        }

        private Optional<TileEntityAltar> getAltar(BlockGetter world, BlockPos pos) {
            BlockEntity te = world.getBlockEntity(pos);
            if (te instanceof TileEntityAltar) {
                return Optional.of((TileEntityAltar)te);
            }
            return Optional.empty();
        }

        @OnlyIn(value=Dist.CLIENT)
        private void crack(ClientLevel world, BlockPos pos, BlockState state, Direction side) {
            if (state.getRenderShape() != RenderShape.INVISIBLE) {
                int posX = pos.getX();
                int posY = pos.getY();
                int posZ = pos.getZ();
                AABB aabb = state.getShape((BlockGetter)world, pos).bounds();
                double x = (double)posX + world.random.nextDouble() * (aabb.maxX - aabb.minX - 0.2) + 0.1 + aabb.minX;
                double y = (double)posY + world.random.nextDouble() * (aabb.maxY - aabb.minY - 0.2) + 0.1 + aabb.minY;
                double z = (double)posZ + world.random.nextDouble() * (aabb.maxZ - aabb.minZ - 0.2) + 0.1 + aabb.minZ;
                if (side == Direction.DOWN) {
                    y = (double)posY + aabb.minY - 0.1;
                }
                if (side == Direction.UP) {
                    y = (double)posY + aabb.maxY + 0.1;
                }
                if (side == Direction.NORTH) {
                    z = (double)posZ + aabb.minZ - 0.1;
                }
                if (side == Direction.SOUTH) {
                    z = (double)posZ + aabb.maxZ + 0.1;
                }
                if (side == Direction.WEST) {
                    x = (double)posX + aabb.minX - 0.1;
                }
                if (side == Direction.EAST) {
                    x = (double)posX + aabb.maxX + 0.1;
                }
                TerrainParticle diggingParticle = new TerrainParticle(world, x, y, z, 0.0, 0.0, 0.0, state);
                Minecraft.getInstance().particleEngine.add(diggingParticle.updateSprite(state, pos).setPower(0.2f).scale(0.6f));
            }
        }
    } : null;

    public BlockAltar() {
        super(BlockBehaviour.Properties.of().sound(SoundType.STONE).strength(2.0f, 2.0f).noOcclusion());
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new TileEntityAltar(pos, state);
    }

    public ItemInteractionResult useItemOn(ItemStack itemStack, BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        return this.getAltar((BlockGetter)worldIn, pos).filter(altar -> handIn == InteractionHand.MAIN_HAND).map(altar -> {
            if (player.isShiftKeyDown() || player.getMainHandItem().isEmpty()) {
                this.takeOutItem(worldIn, (TileEntityAltar)((Object)altar), player);
            } else {
                this.takeInOrCraft(worldIn, (TileEntityAltar)((Object)altar), player);
            }
            altar.refresh();
            return ItemInteractionResult.sidedSuccess((boolean)worldIn.isClientSide);
        }).orElse(super.useItemOn(itemStack, state, worldIn, pos, player, handIn, hit));
    }

    public void onRemove(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!worldIn.isClientSide) {
            this.getAltar((BlockGetter)worldIn, pos).ifPresent(altar -> {
                ItemStack stack = altar.handler.getStackInSlot(0);
                if (!stack.isEmpty()) {
                    Block.popResource((Level)worldIn, (BlockPos)pos.offset(0, 1, 0), (ItemStack)stack);
                }
            });
        }
        super.onRemove(state, worldIn, pos, newState, isMoving);
    }

    public void onBlockExploded(BlockState state, Level world, BlockPos pos, Explosion explosion) {
        if (!world.isClientSide) {
            this.getAltar((BlockGetter)world, pos).ifPresent(altar -> this.restoreStorageBlock(world, pos, altar.getBlockPosList()));
        }
        super.onBlockExploded(state, world, pos, explosion);
    }

    public BlockState playerWillDestroy(Level worldIn, BlockPos pos, BlockState state, Player player) {
        if (!worldIn.isClientSide) {
            this.getAltar((BlockGetter)worldIn, pos).ifPresent(altar -> {
                this.restoreStorageBlock(worldIn, pos, altar.getBlockPosList());
                if (!player.isCreative()) {
                    Block block = altar.getStorageState().getBlock();
                    Block.popResource((Level)worldIn, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)block));
                }
            });
        }
        return super.playerWillDestroy(worldIn, pos, state, player);
    }

    public ItemStack getCloneItemStack(@NotNull BlockState state, @NotNull HitResult target, @NotNull LevelReader world, @NotNull BlockPos pos, @NotNull Player player) {
        return this.getAltar((BlockGetter)world, pos).map(altar -> new ItemStack((ItemLike)altar.getStorageState().getBlock())).orElse(super.getCloneItemStack(state, target, world, pos, player));
    }

    public SoundType getSoundType(BlockState state, LevelReader world, BlockPos pos, @Nullable Entity entity) {
        return this.getAltar((BlockGetter)world, pos).map(altar -> altar.getStorageState().getSoundType()).orElse(super.getSoundType(state, world, pos, entity));
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public boolean isPathfindable(BlockState state, PathComputationType type) {
        return false;
    }

    private void restoreStorageBlock(Level worldIn, BlockPos currentPos, PosListData posList) {
        for (BlockPos storagePos : posList.getData()) {
            if (storagePos.equals((Object)currentPos)) continue;
            this.getAltar((BlockGetter)worldIn, storagePos).ifPresent(altar -> worldIn.setBlock(storagePos, altar.getStorageState(), 3));
        }
    }

    private void takeOutItem(Level world, TileEntityAltar altar, Player player) {
        if (altar.isCanPlaceItem() && !altar.handler.getStackInSlot(0).isEmpty()) {
            ItemStack extractItem = altar.handler.extractItem(0, 1, false);
            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)extractItem);
            this.altarCraft(world, altar, player);
        }
    }

    private void takeInOrCraft(Level world, TileEntityAltar altar, Player playerIn) {
        if (altar.isCanPlaceItem() && altar.handler.getStackInSlot(0).isEmpty()) {
            altar.handler.setStackInSlot(0, playerIn.getMainHandItem().copyWithCount(1));
            if (!playerIn.isCreative()) {
                playerIn.getMainHandItem().shrink(1);
            }
            this.altarCraft(world, altar, playerIn);
        }
    }

    private void altarCraft(Level world, TileEntityAltar altar, Player playerIn) {
        ArrayList<ItemStack> arrayList = new ArrayList<ItemStack>();
        List<BlockPos> posList = altar.getCanPlaceItemPosList().getData();
        for (int i = 0; i < posList.size(); ++i) {
            BlockEntity te = world.getBlockEntity(posList.get(i));
            if (!(te instanceof TileEntityAltar)) continue;
            arrayList.add(i, ((TileEntityAltar)te).getStorageItem());
        }
        if (arrayList.isEmpty()) {
            return;
        }
        CraftingInput craftingInput = CraftingInput.of((int)6, (int)1, arrayList);
        PowerAttachment powerAttachment = (PowerAttachment)playerIn.getData(InitDataAttachment.POWER_NUM);
        world.getRecipeManager().getRecipeFor((RecipeType)InitRecipes.ALTAR_CRAFTING.get(), (RecipeInput)craftingInput, world).ifPresent(recipe -> this.spawnResultEntity(world, playerIn, powerAttachment, recipe.id(), (AltarRecipe)recipe.value(), arrayList, altar));
    }

    private Optional<TileEntityAltar> getAltar(BlockGetter world, BlockPos pos) {
        BlockEntity te = world.getBlockEntity(pos);
        if (te instanceof TileEntityAltar) {
            return Optional.of((TileEntityAltar)te);
        }
        return Optional.empty();
    }

    private void spawnResultEntity(Level world, Player playerIn, PowerAttachment power, ResourceLocation altarId, AltarRecipe altarRecipe, List<ItemStack> inventory, TileEntityAltar altar) {
        if (power.get() >= altarRecipe.getPower()) {
            power.min(altarRecipe.getPower());
            playerIn.setData(InitDataAttachment.POWER_NUM, (Object)new PowerAttachment(power.get()));
            BlockPos centrePos = this.getCentrePos(altar.getBlockPosList(), altar.getBlockPos());
            if (world instanceof ServerLevel) {
                altarRecipe.spawnOutputEntity((ServerLevel)world, centrePos.above(2), inventory);
            }
            this.removeAllAltarItem(world, altar);
            this.spawnParticleInCentre(world, centrePos);
            world.playSound(null, centrePos, (SoundEvent)InitSounds.ALTAR_CRAFT.get(), SoundSource.VOICE, 1.0f, 1.0f);
            if (playerIn instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)playerIn;
                ((AltarCraftTrigger)((Object)InitTrigger.ALTAR_CRAFT.get())).trigger(serverPlayer, altarId);
            }
        } else if (!world.isClientSide) {
            playerIn.sendSystemMessage((Component)Component.translatable((String)"message.touhou_little_maid.altar.not_enough_power"));
        }
    }

    private BlockPos getCentrePos(PosListData posList, BlockPos posClick) {
        int x = 0;
        int y = posClick.getY() - 2;
        int z = 0;
        for (BlockPos pos : posList.getData()) {
            if (pos.getY() != y) continue;
            x += pos.getX();
            z += pos.getZ();
        }
        return new BlockPos(x / 8, y, z / 8);
    }

    private void removeAllAltarItem(Level world, TileEntityAltar altar) {
        for (BlockPos pos : altar.getCanPlaceItemPosList().getData()) {
            this.getAltar((BlockGetter)world, pos).ifPresent(te -> {
                te.handler.setStackInSlot(0, ItemStack.EMPTY);
                te.refresh();
                this.spawnParticleInCentre(world, te.getBlockPos());
            });
        }
    }

    private void spawnParticleInCentre(Level world, BlockPos centrePos) {
        boolean width = true;
        boolean height = true;
        for (int i = 0; i < 5; ++i) {
            double xSpeed = IMaidBauble.RANDOM.nextGaussian() * 0.02;
            double ySpeed = IMaidBauble.RANDOM.nextGaussian() * 0.02;
            double zSpeed = IMaidBauble.RANDOM.nextGaussian() * 0.02;
            world.addParticle((ParticleOptions)ParticleTypes.CLOUD, (double)((float)centrePos.getX() + IMaidBauble.RANDOM.nextFloat() * (float)width * 2.0f - (float)width) - xSpeed * 10.0, (double)((float)centrePos.getY() + IMaidBauble.RANDOM.nextFloat() * (float)height) - ySpeed * 10.0, (double)((float)centrePos.getZ() + IMaidBauble.RANDOM.nextFloat() * (float)width * 2.0f - (float)width) - zSpeed * 10.0, xSpeed, ySpeed, zSpeed);
            world.addParticle((ParticleOptions)ParticleTypes.SMOKE, (double)((float)centrePos.getX() + IMaidBauble.RANDOM.nextFloat() * (float)width * 2.0f - (float)width) - xSpeed * 10.0, (double)((float)centrePos.getY() + IMaidBauble.RANDOM.nextFloat() * (float)height) - ySpeed * 10.0, (double)((float)centrePos.getZ() + IMaidBauble.RANDOM.nextFloat() * (float)width * 2.0f - (float)width) - zSpeed * 10.0, xSpeed, ySpeed, zSpeed);
        }
    }
}

