/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.block;

import com.github.tartaricacid.touhoulittlemaid.client.resource.CustomPackLoader;
import com.github.tartaricacid.touhoulittlemaid.init.InitBlocks;
import com.github.tartaricacid.touhoulittlemaid.init.InitDataComponent;
import com.github.tartaricacid.touhoulittlemaid.init.InitEntities;
import com.github.tartaricacid.touhoulittlemaid.item.ItemGarageKit;
import com.github.tartaricacid.touhoulittlemaid.tileentity.TileEntityGarageKit;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.particle.TerrainParticle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.client.extensions.common.IClientBlockExtensions;
import org.jetbrains.annotations.NotNull;

public class BlockGarageKit
extends Block
implements EntityBlock {
    public static final VoxelShape BLOCK_AABB = Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    public static final IClientBlockExtensions CLIENT_BLOCK_EXTENSIONS = FMLEnvironment.dist == Dist.CLIENT ? new IClientBlockExtensions(){

        public boolean addHitEffects(BlockState state, Level world, HitResult target, ParticleEngine manager) {
            if (target instanceof BlockHitResult) {
                BlockHitResult blockTarget = (BlockHitResult)target;
                if (world instanceof ClientLevel) {
                    ClientLevel clientWorld = (ClientLevel)world;
                    BlockPos pos = blockTarget.getBlockPos();
                    this.crack(clientWorld, pos, Blocks.CLAY.defaultBlockState(), blockTarget.getDirection());
                }
            }
            return true;
        }

        public boolean addDestroyEffects(BlockState state, Level world, BlockPos pos, ParticleEngine manager) {
            Minecraft.getInstance().particleEngine.destroy(pos, Blocks.CLAY.defaultBlockState());
            return true;
        }

        @OnlyIn(value=Dist.CLIENT)
        private void crack(ClientLevel world, BlockPos pos, BlockState state, Direction side) {
            if (state.getRenderShape() != RenderShape.INVISIBLE) {
                int posX = pos.getX();
                int posY = pos.getY();
                int posZ = pos.getZ();
                AABB aabb = state.getShape((BlockGetter)world, pos).bounds();
                double x = (double)posX + world.random.nextDouble() * (aabb.maxX - aabb.minX - 0.2) + 0.1 + aabb.minX;
                double y = (double)posY + world.random.nextDouble() * (aabb.maxY - aabb.minY - 0.2) + 0.1 + aabb.minY;
                double z = (double)posZ + world.random.nextDouble() * (aabb.maxZ - aabb.minZ - 0.2) + 0.1 + aabb.minZ;
                if (side == Direction.DOWN) {
                    y = (double)posY + aabb.minY - 0.1;
                }
                if (side == Direction.UP) {
                    y = (double)posY + aabb.maxY + 0.1;
                }
                if (side == Direction.NORTH) {
                    z = (double)posZ + aabb.minZ - 0.1;
                }
                if (side == Direction.SOUTH) {
                    z = (double)posZ + aabb.maxZ + 0.1;
                }
                if (side == Direction.WEST) {
                    x = (double)posX + aabb.minX - 0.1;
                }
                if (side == Direction.EAST) {
                    x = (double)posX + aabb.maxX + 0.1;
                }
                TerrainParticle diggingParticle = new TerrainParticle(world, x, y, z, 0.0, 0.0, 0.0, state);
                Minecraft.getInstance().particleEngine.add(diggingParticle.updateSprite(state, pos).setPower(0.2f).scale(0.6f));
            }
        }
    } : null;

    public BlockGarageKit() {
        super(BlockBehaviour.Properties.of().sound(SoundType.MUD).strength(1.0f, 2.0f).noOcclusion());
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void fillItemCategory(CreativeModeTab.Output items) {
        for (String modelId : CustomPackLoader.MAID_MODELS.getModelIdSet()) {
            ItemStack stack = new ItemStack((ItemLike)InitBlocks.GARAGE_KIT.get());
            CustomData customData = (CustomData)stack.get(InitDataComponent.MAID_INFO);
            CompoundTag data = customData == null ? new CompoundTag() : customData.copyTag();
            data.putString("id", Objects.requireNonNull(BuiltInRegistries.ENTITY_TYPE.getKey(InitEntities.MAID.get())).toString());
            data.putString("model_id", modelId);
            data.putBoolean("IsYsmModel", false);
            stack.set(InitDataComponent.MAID_INFO, (Object)CustomData.of((CompoundTag)data));
            items.accept(stack);
        }
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new TileEntityGarageKit(pos, state);
    }

    public void onRemove(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockGarageKit.popResource((Level)worldIn, (BlockPos)pos, (ItemStack)this.getGarageKitFromWorld((BlockGetter)worldIn, pos));
        super.onRemove(state, worldIn, pos, newState, isMoving);
    }

    public void setPlacedBy(Level worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        this.getGarageKit((BlockGetter)worldIn, pos).ifPresent(te -> {
            Direction facing = Direction.SOUTH;
            if (placer != null) {
                facing = placer.getDirection().getOpposite();
            }
            te.setData(facing, ItemGarageKit.getMaidData(stack).copyTag());
        });
    }

    public ItemStack getCloneItemStack(@NotNull BlockState state, @NotNull HitResult target, @NotNull LevelReader world, @NotNull BlockPos pos, @NotNull Player player) {
        return this.getGarageKitFromWorld((BlockGetter)world, pos);
    }

    public ItemInteractionResult useItemOn(ItemStack itemStack, BlockState state, Level worldIn, BlockPos pos, Player playerIn, InteractionHand hand, BlockHitResult hit) {
        ItemStack stack = playerIn.getItemInHand(hand);
        if (!(worldIn instanceof ServerLevel) || !(stack.getItem() instanceof SpawnEggItem)) {
            return ItemInteractionResult.SKIP_DEFAULT_BLOCK_INTERACTION;
        }
        BlockEntity tile = worldIn.getBlockEntity(pos);
        if (!(tile instanceof TileEntityGarageKit)) {
            return ItemInteractionResult.SKIP_DEFAULT_BLOCK_INTERACTION;
        }
        TileEntityGarageKit garageKit = (TileEntityGarageKit)tile;
        EntityType type = ((SpawnEggItem)stack.getItem()).getType(stack);
        ResourceLocation key = BuiltInRegistries.ENTITY_TYPE.getKey((Object)type);
        if (key == null) {
            return ItemInteractionResult.SKIP_DEFAULT_BLOCK_INTERACTION;
        }
        String id = key.toString();
        CompoundTag data = new CompoundTag();
        data.putString("id", id);
        Entity entity = type.create(worldIn);
        if (entity instanceof Mob) {
            Mob mobEntity = (Mob)entity;
            mobEntity.finalizeSpawn((ServerLevelAccessor)((ServerLevel)worldIn), worldIn.getCurrentDifficultyAt(pos), MobSpawnType.SPAWN_EGG, null);
            CustomData.of((CompoundTag)data).loadInto((Entity)mobEntity);
            mobEntity.addAdditionalSaveData(data);
        }
        garageKit.setData(garageKit.getFacing(), data);
        return ItemInteractionResult.SUCCESS;
    }

    private ItemStack getGarageKitFromWorld(BlockGetter world, BlockPos pos) {
        ItemStack stack = new ItemStack((ItemLike)InitBlocks.GARAGE_KIT.get());
        this.getGarageKit(world, pos).ifPresent(te -> stack.set(InitDataComponent.MAID_INFO, (Object)CustomData.of((CompoundTag)te.getExtraData())));
        return stack;
    }

    private Optional<TileEntityGarageKit> getGarageKit(BlockGetter world, BlockPos pos) {
        BlockEntity te = world.getBlockEntity(pos);
        if (te instanceof TileEntityGarageKit) {
            return Optional.of((TileEntityGarageKit)te);
        }
        return Optional.empty();
    }

    @Nullable
    public EntityType<?> getType(@Nullable CompoundTag nbt) {
        CompoundTag compound;
        if (nbt != null && nbt.contains("EntityTag", 10) && (compound = nbt.getCompound("EntityTag")).contains("id", 8)) {
            return EntityType.byString((String)compound.getString("id")).orElse(null);
        }
        return null;
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return BLOCK_AABB;
    }
}

