/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.block;

import com.github.tartaricacid.touhoulittlemaid.advancements.maid.MaidEventTrigger;
import com.github.tartaricacid.touhoulittlemaid.api.block.IBoardGameBlock;
import com.github.tartaricacid.touhoulittlemaid.api.game.gomoku.Point;
import com.github.tartaricacid.touhoulittlemaid.api.game.gomoku.Statue;
import com.github.tartaricacid.touhoulittlemaid.block.BlockJoy;
import com.github.tartaricacid.touhoulittlemaid.block.properties.GomokuPart;
import com.github.tartaricacid.touhoulittlemaid.config.subconfig.MaidConfig;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.MaidGomokuAI;
import com.github.tartaricacid.touhoulittlemaid.entity.favorability.Type;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntitySit;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import com.github.tartaricacid.touhoulittlemaid.init.InitSounds;
import com.github.tartaricacid.touhoulittlemaid.init.InitTrigger;
import com.github.tartaricacid.touhoulittlemaid.network.message.GomokuClientPackage;
import com.github.tartaricacid.touhoulittlemaid.network.message.SpawnParticlePackage;
import com.github.tartaricacid.touhoulittlemaid.tileentity.TileEntityGomoku;
import com.github.tartaricacid.touhoulittlemaid.tileentity.TileEntityJoy;
import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.network.PacketDistributor;

public class BlockGomoku
extends BlockJoy
implements IBoardGameBlock {
    public static final EnumProperty<GomokuPart> PART = EnumProperty.create((String)"part", GomokuPart.class);
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final VoxelShape LEFT_UP = Block.box((double)8.0, (double)0.0, (double)8.0, (double)16.0, (double)2.0, (double)16.0);
    public static final VoxelShape LEFT_UP_WITH_BOX = Shapes.or((VoxelShape)LEFT_UP, (VoxelShape)Block.box((double)11.0, (double)0.0, (double)2.0, (double)16.0, (double)4.0, (double)7.0));
    public static final VoxelShape UP = Block.box((double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)2.0, (double)16.0);
    public static final VoxelShape RIGHT_UP = Block.box((double)0.0, (double)0.0, (double)8.0, (double)8.0, (double)2.0, (double)16.0);
    public static final VoxelShape RIGHT_UP_WITH_BOX = Shapes.or((VoxelShape)RIGHT_UP, (VoxelShape)Block.box((double)9.0, (double)0.0, (double)11.0, (double)14.0, (double)4.0, (double)16.0));
    public static final VoxelShape LEFT_CENTER = Block.box((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);
    public static final VoxelShape CENTER = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);
    public static final VoxelShape RIGHT_CENTER = Block.box((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)2.0, (double)16.0);
    public static final VoxelShape LEFT_DOWN = Block.box((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)8.0);
    public static final VoxelShape LEFT_DOWN_WITH_BOX = Shapes.or((VoxelShape)LEFT_DOWN, (VoxelShape)Block.box((double)2.0, (double)0.0, (double)0.0, (double)7.0, (double)4.0, (double)5.0));
    public static final VoxelShape DOWN = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)8.0);
    public static final VoxelShape RIGHT_DOWN = Block.box((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)2.0, (double)8.0);
    public static final VoxelShape RIGHT_DOWN_WITH_BOX = Shapes.or((VoxelShape)RIGHT_DOWN, (VoxelShape)Block.box((double)0.0, (double)0.0, (double)9.0, (double)5.0, (double)4.0, (double)14.0));

    public BlockGomoku() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).sound(SoundType.WOOD).strength(2.0f, 3.0f).forceSolidOn().noOcclusion());
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(PART, (Comparable)((Object)GomokuPart.CENTER))).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    private static void handleGomokuRemove(Level world, BlockPos pos, BlockState state) {
        if (!world.isClientSide) {
            GomokuPart part = (GomokuPart)((Object)state.getValue(PART));
            BlockPos centerPos = pos.subtract(new Vec3i(part.getPosX(), 0, part.getPosY()));
            BlockEntity te = world.getBlockEntity(centerPos);
            BlockGomoku.popResource((Level)world, (BlockPos)centerPos, (ItemStack)((Item)InitItems.GOMOKU.get()).getDefaultInstance());
            if (te instanceof TileEntityGomoku) {
                for (int i = -1; i < 2; ++i) {
                    for (int j = -1; j < 2; ++j) {
                        world.setBlockAndUpdate(centerPos.offset(i, 0, j), Blocks.AIR.defaultBlockState());
                    }
                }
            }
        }
    }

    @Nullable
    private static int[] getChessPos(double x, double y, GomokuPart part) {
        switch (part) {
            case LEFT_UP: {
                return BlockGomoku.getData(x, y, 0.505, 0.505, 0.54, 0.54, 0, 0);
            }
            case UP: {
                return BlockGomoku.getData(x, y, 0.037, 0.505, 0.08, 0.54, 4, 0);
            }
            case RIGHT_UP: {
                return BlockGomoku.getData(x, y, -0.037, 0.505, -0.01, 0.54, 11, 0);
            }
            case LEFT_CENTER: {
                return BlockGomoku.getData(x, y, 0.505, 0.037, 0.54, 0.07, 0, 4);
            }
            case CENTER: {
                return BlockGomoku.getData(x, y, 0.037, 0.037, 0.08, 0.07, 4, 4);
            }
            case RIGHT_CENTER: {
                return BlockGomoku.getData(x, y, -0.037, 0.037, -0.01, 0.07, 11, 4);
            }
            case LEFT_DOWN: {
                return BlockGomoku.getData(x, y, 0.505, 0.0, 0.54, 0.0, 0, 11);
            }
            case DOWN: {
                return BlockGomoku.getData(x, y, 0.037, 0.0, 0.08, 0.0, 4, 11);
            }
            case RIGHT_DOWN: {
                return BlockGomoku.getData(x, y, -0.037, 0.0, -0.01, 0.0, 11, 11);
            }
        }
        return null;
    }

    private static boolean isClickChessBox(double x, double y, GomokuPart part, Direction direction) {
        if (direction.getAxis() == Direction.Axis.Z) {
            if (part == GomokuPart.RIGHT_UP) {
                return 0.5625 <= x && x <= 0.875 && 0.6875 <= y && y <= 1.0;
            }
            if (part == GomokuPart.LEFT_DOWN) {
                return 0.125 <= x && x <= 0.4375 && 0.0 <= y && y <= 0.3125;
            }
        }
        if (direction.getAxis() == Direction.Axis.X) {
            if (part == GomokuPart.LEFT_UP) {
                return 0.6875 <= x && x <= 1.0 && 0.125 <= y && y <= 0.4375;
            }
            if (part == GomokuPart.RIGHT_DOWN) {
                return 0.0 <= x && x <= 0.3125 && 0.5625 <= y && y <= 0.875;
            }
        }
        return false;
    }

    @Nullable
    private static int[] getData(double x, double y, double xOffset, double yOffset, double xStartOffset, double yStartOffset, int xIndexOffset, int yIndexOffset) {
        boolean checkClick;
        int xIndex = (int)((x - xOffset) / 0.1316);
        int yIndex = (int)((y - yOffset) / 0.1316);
        double xStart = xStartOffset + (double)xIndex * 0.1316;
        double xEnd = xStart + 0.07;
        double yStart = yStartOffset + (double)yIndex * 0.1316;
        double yEnd = yStart + 0.07;
        boolean checkIndex = 0 <= (xIndex += xIndexOffset) && xIndex <= 14 && 0 <= (yIndex += yIndexOffset) && yIndex <= 14;
        boolean bl = checkClick = xStart < x && x < xEnd && yStart < y && y < yEnd;
        if (checkIndex && checkClick) {
            return new int[]{xIndex, yIndex};
        }
        return null;
    }

    @Override
    protected Vec3 sitPosition() {
        return Vec3.ZERO;
    }

    @Override
    protected String getTypeName() {
        return Type.GOMOKU.getTypeName();
    }

    @Override
    protected int sitYRot() {
        return 0;
    }

    public BlockState playerWillDestroy(Level world, BlockPos pos, BlockState state, Player player) {
        BlockGomoku.handleGomokuRemove(world, pos, state);
        return super.playerWillDestroy(world, pos, state, player);
    }

    public void onBlockExploded(BlockState state, Level world, BlockPos pos, Explosion explosion) {
        BlockGomoku.handleGomokuRemove(world, pos, state);
        super.onBlockExploded(state, world, pos, explosion);
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos centerPos = context.getClickedPos();
        for (int i = -1; i < 2; ++i) {
            for (int j = -1; j < 2; ++j) {
                BlockPos searchPos = centerPos.offset(i, 0, j);
                if (context.getLevel().getBlockState(searchPos).canBeReplaced(context)) continue;
                return null;
            }
        }
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    public void setPlacedBy(Level worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.setPlacedBy(worldIn, pos, state, placer, stack);
        if (worldIn.isClientSide) {
            return;
        }
        for (int i = -1; i < 2; ++i) {
            for (int j = -1; j < 2; ++j) {
                BlockPos searchPos = pos.offset(i, 0, j);
                GomokuPart part = GomokuPart.getPartByPos(i, j);
                if (part == null || part.isCenter()) continue;
                worldIn.setBlock(searchPos, (BlockState)state.setValue(PART, (Comparable)((Object)part)), 3);
            }
        }
    }

    @Override
    public ItemInteractionResult useItemOn(ItemStack itemStack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (hand == InteractionHand.MAIN_HAND && player.getMainHandItem().isEmpty()) {
                Entity entity;
                GomokuPart part = (GomokuPart)((Object)state.getValue(PART));
                BlockPos centerPos = pos.subtract(new Vec3i(part.getPosX(), 0, part.getPosY()));
                BlockEntity te = level.getBlockEntity(centerPos);
                if (!(te instanceof TileEntityGomoku)) {
                    return ItemInteractionResult.FAIL;
                }
                TileEntityGomoku gomoku = (TileEntityGomoku)te;
                Vec3 location = hit.getLocation().subtract((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
                Direction facing = (Direction)state.getValue((Property)FACING);
                if (BlockGomoku.isClickChessBox(location.x, location.z, part, facing)) {
                    Entity entity2;
                    level.playSound(null, centerPos, (SoundEvent)InitSounds.GOMOKU_RESET.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                    gomoku.reset();
                    gomoku.refresh();
                    Entity sitEntity = serverLevel.getEntity(gomoku.getSitId());
                    if (sitEntity != null && sitEntity.isAlive() && (entity2 = sitEntity.getFirstPassenger()) instanceof EntityMaid) {
                        EntityMaid maid = (EntityMaid)entity2;
                        maid.getGameRecordManager().resetStatue();
                    }
                    return ItemInteractionResult.SUCCESS;
                }
                Entity sitEntity = serverLevel.getEntity(gomoku.getSitId());
                if (sitEntity == null || !sitEntity.isAlive() || !((entity = sitEntity.getFirstPassenger()) instanceof EntityMaid)) {
                    player.sendSystemMessage((Component)Component.translatable((String)"message.touhou_little_maid.gomoku.no_maid"));
                    return ItemInteractionResult.FAIL;
                }
                EntityMaid maid = (EntityMaid)entity;
                if (((Boolean)MaidConfig.MAID_GOMOKU_OWNER_LIMIT.get()).booleanValue() && !maid.isOwnedBy((LivingEntity)player)) {
                    player.sendSystemMessage((Component)Component.translatable((String)"message.touhou_little_maid.gomoku.not_owner"));
                    return ItemInteractionResult.FAIL;
                }
                if (!gomoku.isPlayerTurn()) {
                    return ItemInteractionResult.FAIL;
                }
                byte[][] chessData = gomoku.getChessData();
                int[] clickPos = BlockGomoku.getChessPos(location.x, location.z, part);
                if (clickPos == null) {
                    return ItemInteractionResult.FAIL;
                }
                Point playerPoint = new Point(clickPos[0], clickPos[1], 1);
                if (gomoku.isInProgress() && chessData[playerPoint.x][playerPoint.y] == 0) {
                    gomoku.setChessData(playerPoint.x, playerPoint.y, playerPoint.type);
                    Statue statue = MaidGomokuAI.getStatue(chessData, playerPoint);
                    if (statue == Statue.WIN && maid.isOwnedBy((LivingEntity)player)) {
                        ServerPlayer serverPlayer;
                        maid.getFavorabilityManager().apply(Type.GOMOKU_WIN);
                        maid.getGameRecordManager().markStatue(false);
                        int rankBefore = MaidGomokuAI.getRank(maid);
                        maid.getGameRecordManager().increaseGomokuWinCount();
                        int rankAfter = MaidGomokuAI.getRank(maid);
                        if (rankBefore < rankAfter && player instanceof ServerPlayer) {
                            serverPlayer = (ServerPlayer)player;
                            PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new SpawnParticlePackage(maid.getId(), SpawnParticlePackage.Type.RANK_UP), (CustomPacketPayload[])new CustomPacketPayload[0]);
                        }
                        if (player instanceof ServerPlayer) {
                            serverPlayer = (ServerPlayer)player;
                            ((MaidEventTrigger)((Object)InitTrigger.MAID_EVENT.get())).trigger(serverPlayer, "win_gomoku");
                        }
                    }
                    gomoku.setInProgress(statue == Statue.IN_PROGRESS);
                    level.playSound(null, pos, (SoundEvent)InitSounds.GOMOKU.get(), SoundSource.BLOCKS, 1.0f, 0.8f + level.random.nextFloat() * 0.4f);
                    if (gomoku.isInProgress() && player instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)player;
                        gomoku.setPlayerTurn(false);
                        PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new GomokuClientPackage(centerPos, chessData, playerPoint, maid.getGameRecordManager().getGomokuWinCount()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    }
                    gomoku.refresh();
                    return ItemInteractionResult.SUCCESS;
                }
            }
        }
        return ItemInteractionResult.SKIP_DEFAULT_BLOCK_INTERACTION;
    }

    @Override
    public void startMaidSit(EntityMaid maid, BlockState state, Level worldIn, BlockPos pos) {
        if (worldIn instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)worldIn;
            BlockEntity blockEntity = worldIn.getBlockEntity(pos);
            if (blockEntity instanceof TileEntityJoy) {
                TileEntityJoy joy = (TileEntityJoy)blockEntity;
                Entity oldSitEntity = serverLevel.getEntity(joy.getSitId());
                if (oldSitEntity != null && oldSitEntity.isAlive()) {
                    return;
                }
                Direction face = ((Direction)state.getValue((Property)FACING)).getClockWise();
                Vec3 position = new Vec3(0.5 + (double)face.getStepX() * 1.5, 0.1, 0.5 + (double)face.getStepZ() * 1.5);
                EntitySit newSitEntity = new EntitySit(worldIn, Vec3.atLowerCornerWithOffset((Vec3i)pos, (double)position.x, (double)position.y, (double)position.z), this.getTypeName(), pos);
                newSitEntity.setYRot(face.getOpposite().toYRot() + (float)this.sitYRot());
                worldIn.addFreshEntity((Entity)newSitEntity);
                joy.setSitId(newSitEntity.getUUID());
                joy.setChanged();
                maid.startRiding(newSitEntity);
            }
        }
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{PART, FACING});
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        if (((GomokuPart)((Object)state.getValue(PART))).isCenter()) {
            return new TileEntityGomoku(pos, state);
        }
        return null;
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return BlockGomoku.simpleCodec(properties -> new BlockGomoku());
    }

    @Override
    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        switch ((GomokuPart)((Object)state.getValue(PART))) {
            case LEFT_UP: {
                if (((Direction)state.getValue((Property)FACING)).getAxis() == Direction.Axis.X) {
                    return LEFT_UP_WITH_BOX;
                }
                return LEFT_UP;
            }
            case UP: {
                return UP;
            }
            case RIGHT_UP: {
                if (((Direction)state.getValue((Property)FACING)).getAxis() == Direction.Axis.Z) {
                    return RIGHT_UP_WITH_BOX;
                }
                return RIGHT_UP;
            }
            case LEFT_CENTER: {
                return LEFT_CENTER;
            }
            case RIGHT_CENTER: {
                return RIGHT_CENTER;
            }
            case LEFT_DOWN: {
                if (((Direction)state.getValue((Property)FACING)).getAxis() == Direction.Axis.Z) {
                    return LEFT_DOWN_WITH_BOX;
                }
                return LEFT_DOWN;
            }
            case DOWN: {
                return DOWN;
            }
            case RIGHT_DOWN: {
                if (((Direction)state.getValue((Property)FACING)).getAxis() == Direction.Axis.X) {
                    return RIGHT_DOWN_WITH_BOX;
                }
                return RIGHT_DOWN;
            }
        }
        return CENTER;
    }
}

