/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.block.multiblock;

import com.github.tartaricacid.touhoulittlemaid.api.block.IMultiBlock;
import com.github.tartaricacid.touhoulittlemaid.init.InitBlocks;
import com.github.tartaricacid.touhoulittlemaid.tileentity.TileEntityAltar;
import com.github.tartaricacid.touhoulittlemaid.util.PosListData;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class MultiBlockAltar
implements IMultiBlock {
    private static final ResourceLocation ALTAR_SOUTH = ResourceLocation.fromNamespaceAndPath((String)"touhou_little_maid", (String)"altar_south");
    private static final ResourceLocation ALTAR_NORTH = ResourceLocation.fromNamespaceAndPath((String)"touhou_little_maid", (String)"altar_north");
    private static final ResourceLocation ALTAR_EAST = ResourceLocation.fromNamespaceAndPath((String)"touhou_little_maid", (String)"altar_east");
    private static final ResourceLocation ALTAR_WEST = ResourceLocation.fromNamespaceAndPath((String)"touhou_little_maid", (String)"altar_west");
    private static final BlockPos SOUTH_POS = new BlockPos(-4, -3, 0);
    private static final BlockPos NORTH_POS = new BlockPos(-3, -3, -7);
    private static final BlockPos EAST_POS = new BlockPos(0, -3, -3);
    private static final BlockPos WEST_POS = new BlockPos(-7, -3, -4);

    @Override
    public boolean isCoreBlock(BlockState blockState) {
        return blockState.is(Blocks.RED_WOOL);
    }

    @Override
    public boolean isMatch(Level world, BlockPos posStart, Direction direction, StructureTemplate template) {
        StructureTemplate.Palette palette = (StructureTemplate.Palette)template.palettes.getFirst();
        for (StructureTemplate.StructureBlockInfo blockInfo : palette.blocks()) {
            BlockState worldState = world.getBlockState(posStart.offset((Vec3i)blockInfo.pos()));
            BlockState infoState = blockInfo.state();
            if (!(infoState.is(Blocks.OAK_LOG) ? !worldState.is(BlockTags.LOGS) : !worldState.equals(infoState))) continue;
            return false;
        }
        return true;
    }

    @Override
    public void build(Level worldIn, BlockPos posStart, Direction direction, StructureTemplate template) {
        PosListData posList = new PosListData();
        PosListData canPlaceItemPosList = new PosListData();
        StructureTemplate.Palette palette = (StructureTemplate.Palette)template.palettes.getFirst();
        for (StructureTemplate.StructureBlockInfo blockInfo : palette.blocks()) {
            posList.add(posStart.offset((Vec3i)blockInfo.pos()));
            if (blockInfo.pos().getY() != 2 || !blockInfo.state().is(BlockTags.LOGS)) continue;
            canPlaceItemPosList.add(posStart.offset((Vec3i)blockInfo.pos()));
        }
        BlockPos currentCenterPos = posStart.subtract((Vec3i)this.getCenterPos(direction));
        for (StructureTemplate.StructureBlockInfo blockInfo : palette.blocks()) {
            BlockPos currentPos = posStart.offset((Vec3i)blockInfo.pos());
            BlockState currentState = worldIn.getBlockState(currentPos);
            worldIn.setBlock(currentPos, ((Block)InitBlocks.ALTAR.get()).defaultBlockState(), 3);
            BlockEntity te = worldIn.getBlockEntity(currentPos);
            if (!(te instanceof TileEntityAltar)) continue;
            boolean isRender = currentPos.equals((Object)currentCenterPos);
            boolean canPlaceItem = blockInfo.pos().getY() == 2 && blockInfo.state().is(BlockTags.LOGS);
            ((TileEntityAltar)te).setForgeData(currentState, isRender, canPlaceItem, direction, posList, canPlaceItemPosList);
        }
    }

    @Override
    public boolean directionIsSuitable(Direction direction) {
        return direction != Direction.DOWN && direction != Direction.UP;
    }

    @Override
    public BlockPos getCenterPos(Direction facing) {
        return switch (facing) {
            case Direction.NORTH -> SOUTH_POS;
            case Direction.EAST -> WEST_POS;
            case Direction.WEST -> EAST_POS;
            default -> NORTH_POS;
        };
    }

    @Override
    public StructureTemplate getTemplate(ServerLevel world, Direction facing) {
        return switch (facing) {
            case Direction.NORTH -> this.getAltarTemplate(world, ALTAR_SOUTH);
            case Direction.EAST -> this.getAltarTemplate(world, ALTAR_WEST);
            case Direction.WEST -> this.getAltarTemplate(world, ALTAR_EAST);
            default -> this.getAltarTemplate(world, ALTAR_NORTH);
        };
    }

    private StructureTemplate getAltarTemplate(ServerLevel world, ResourceLocation location) {
        return world.getStructureManager().getOrCreate(location);
    }
}

