/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.animation;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.api.ILittleMaid;
import com.github.tartaricacid.touhoulittlemaid.api.animation.ICustomAnimation;
import com.github.tartaricacid.touhoulittlemaid.api.entity.IMaid;
import com.github.tartaricacid.touhoulittlemaid.client.animation.script.ModelRendererWrapper;
import com.github.tartaricacid.touhoulittlemaid.client.animation.special.SwimAnimation;
import com.github.tartaricacid.touhoulittlemaid.client.animation.special.TridentAnimation;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.animated.AnimatedGeoModel;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.HashMap;
import java.util.List;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;

public final class HardcodedAnimationManger {
    private static final List<ICustomAnimation<? extends LivingEntity>> ANIMATIONS = Lists.newLinkedList();

    public static void init() {
        HardcodedAnimationManger manager = new HardcodedAnimationManger();
        manager.addMaidAnimation(new SwimAnimation());
        manager.addMaidAnimation(new TridentAnimation());
        for (ILittleMaid littleMaid : TouhouLittleMaid.EXTENSIONS) {
            littleMaid.addHardcodeAnimation(manager);
        }
    }

    public static void playMaidAnimation(IMaid maid, HashMap<String, ModelRendererWrapper> models, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        for (ICustomAnimation<? extends LivingEntity> animation : ANIMATIONS) {
            animation.setRotationAngles((LivingEntity)maid.asEntity(), models, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        }
    }

    public static void playGeckoMaidAnimation(IMaid maid, AnimatedGeoModel model, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        for (ICustomAnimation<? extends LivingEntity> animation : ANIMATIONS) {
            animation.setGeckoRotationAngles((LivingEntity)maid.asEntity(), model, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        }
    }

    public static void setupRotations(Mob entity, PoseStack poseStack, float ageInTicks, float rotationYaw, float partialTicks, boolean isGecko) {
        for (ICustomAnimation<? extends LivingEntity> animation : ANIMATIONS) {
            if (isGecko) {
                animation.setupGeckoRotations((LivingEntity)entity, poseStack, ageInTicks, rotationYaw, partialTicks);
                continue;
            }
            animation.setupRotations((LivingEntity)entity, poseStack, ageInTicks, rotationYaw, partialTicks);
        }
    }

    public void addMaidAnimation(ICustomAnimation<Mob> animation) {
        ANIMATIONS.add(animation);
    }
}

