/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.animation.gecko;

import com.github.tartaricacid.touhoulittlemaid.api.entity.IMaid;
import com.github.tartaricacid.touhoulittlemaid.client.animation.gecko.AnimationState;
import com.github.tartaricacid.touhoulittlemaid.client.animation.gecko.condition.ConditionArmor;
import com.github.tartaricacid.touhoulittlemaid.client.animation.gecko.condition.ConditionManager;
import com.github.tartaricacid.touhoulittlemaid.client.animation.gecko.condition.ConditionalChair;
import com.github.tartaricacid.touhoulittlemaid.client.animation.gecko.condition.ConditionalHold;
import com.github.tartaricacid.touhoulittlemaid.client.animation.gecko.condition.ConditionalPassenger;
import com.github.tartaricacid.touhoulittlemaid.client.animation.gecko.condition.ConditionalSwing;
import com.github.tartaricacid.touhoulittlemaid.client.animation.gecko.condition.ConditionalUse;
import com.github.tartaricacid.touhoulittlemaid.client.animation.gecko.condition.ConditionalVehicle;
import com.github.tartaricacid.touhoulittlemaid.client.entity.GeckoMaidEntity;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntityChair;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntitySit;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.MaidGameRecordManager;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.PlayState;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.builder.AnimationBuilder;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.builder.ILoopType;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.event.predicate.AnimationEvent;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.resource.GeckoLibCache;
import it.unimi.dsi.fastutil.objects.ReferenceArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public final class AnimationManager {
    private static AnimationManager MANAGER;
    private final ReferenceArrayList<AnimationState>[] data = new ReferenceArrayList[5];

    public AnimationManager() {
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = new ReferenceArrayList(6);
        }
    }

    public static AnimationManager getInstance() {
        if (MANAGER == null) {
            MANAGER = new AnimationManager();
        }
        return MANAGER;
    }

    @Nonnull
    public static PlayState playLoopAnimation(AnimationEvent<?> event, String animationName) {
        return AnimationManager.playAnimation(event, animationName, ILoopType.EDefaultLoopTypes.LOOP);
    }

    @Nonnull
    private static PlayState playAnimation(AnimationEvent<?> event, String animationName, ILoopType loopType) {
        event.getController().setAnimation(new AnimationBuilder().addAnimation(animationName, loopType));
        return PlayState.CONTINUE;
    }

    @Nonnull
    private static PlayState playAnimation(AnimationEvent<?> event, String animationName) {
        event.getController().setAnimation(new AnimationBuilder().addAnimation(animationName));
        return PlayState.CONTINUE;
    }

    public void register(AnimationState state) {
        this.data[state.getPriority()].add((Object)state);
    }

    public PlayState predicateParallel(AnimationEvent<?> event, String animationName) {
        if (Minecraft.getInstance().isPaused()) {
            return PlayState.STOP;
        }
        return AnimationManager.playLoopAnimation(event, animationName);
    }

    @NotNull
    public PlayState predicateMain(AnimationEvent<GeckoMaidEntity<?>> event) {
        IMaid maid = event.getAnimatableEntity().getMaid();
        if (maid == null) {
            return PlayState.STOP;
        }
        for (int i = 0; i <= 4; ++i) {
            PlayState vehicleAnimation;
            if (i == 1 && (vehicleAnimation = this.getVehicleAnimation(event)) != null) {
                return vehicleAnimation;
            }
            for (AnimationState state : this.data[i]) {
                if (!state.getPredicate().test(maid, event)) continue;
                String animationName = state.getAnimationName();
                ILoopType loopType = state.getLoopType();
                return AnimationManager.playAnimation(event, animationName, loopType);
            }
        }
        return PlayState.STOP;
    }

    public PlayState predicateOffhandHold(AnimationEvent<GeckoMaidEntity<?>> event) {
        ItemStack offhandItem;
        IMaid maid = event.getAnimatableEntity().getMaid();
        if (maid == null) {
            return PlayState.STOP;
        }
        if (!maid.asEntity().swinging && !maid.asEntity().isUsingItem() && (offhandItem = maid.asEntity().getItemInHand(InteractionHand.OFF_HAND)).is(Items.CROSSBOW) && CrossbowItem.isCharged((ItemStack)offhandItem)) {
            return AnimationManager.playAnimation(event, "hold_offhand:charged_crossbow", ILoopType.EDefaultLoopTypes.LOOP);
        }
        if (this.checkSwingAndUse(maid, InteractionHand.OFF_HAND)) {
            String name;
            ResourceLocation id;
            ConditionalHold conditionalHold;
            offhandItem = maid.asEntity().getItemInHand(InteractionHand.OFF_HAND);
            if (!this.isSameItem(maid, offhandItem, InteractionHand.OFF_HAND)) {
                maid.getHandItemsForAnimation()[InteractionHand.OFF_HAND.ordinal()] = offhandItem;
                AnimationManager.playAnimation(event, "empty", ILoopType.EDefaultLoopTypes.LOOP);
            }
            if ((conditionalHold = ConditionManager.getHoldOffhand(id = event.getAnimatableEntity().getAnimationFileLocation())) != null && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{name = conditionalHold.doTest(maid, InteractionHand.OFF_HAND)})) {
                return AnimationManager.playAnimation(event, name, ILoopType.EDefaultLoopTypes.LOOP);
            }
        }
        return PlayState.STOP;
    }

    public PlayState predicateMainhandHold(AnimationEvent<GeckoMaidEntity<?>> event) {
        ItemStack mainHandItem;
        IMaid maid = event.getAnimatableEntity().getMaid();
        if (maid == null) {
            return PlayState.STOP;
        }
        if (!maid.asEntity().swinging && !maid.asEntity().isUsingItem()) {
            mainHandItem = maid.asEntity().getItemInHand(InteractionHand.MAIN_HAND);
            if (mainHandItem.is(Items.CROSSBOW) && CrossbowItem.isCharged((ItemStack)mainHandItem)) {
                return AnimationManager.playAnimation(event, "hold_mainhand:charged_crossbow", ILoopType.EDefaultLoopTypes.LOOP);
            }
            if (maid.hasFishingHook()) {
                return AnimationManager.playAnimation(event, "hold_mainhand:fishing", ILoopType.EDefaultLoopTypes.LOOP);
            }
        }
        if (this.checkSwingAndUse(maid, InteractionHand.MAIN_HAND)) {
            String name;
            ResourceLocation id;
            ConditionalHold conditionalHold;
            mainHandItem = maid.asEntity().getItemInHand(InteractionHand.MAIN_HAND);
            if (!this.isSameItem(maid, mainHandItem, InteractionHand.MAIN_HAND)) {
                maid.getHandItemsForAnimation()[InteractionHand.MAIN_HAND.ordinal()] = mainHandItem;
                AnimationManager.playAnimation(event, "empty", ILoopType.EDefaultLoopTypes.LOOP);
            }
            if ((conditionalHold = ConditionManager.getHoldMainhand(id = event.getAnimatableEntity().getAnimationFileLocation())) != null && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{name = conditionalHold.doTest(maid, InteractionHand.MAIN_HAND)})) {
                return AnimationManager.playAnimation(event, name, ILoopType.EDefaultLoopTypes.LOOP);
            }
        }
        return PlayState.STOP;
    }

    private boolean isSameItem(IMaid maid, ItemStack maidItem, InteractionHand hand) {
        ItemStack preItem = maid.getHandItemsForAnimation()[hand.ordinal()];
        if (preItem.isDamaged()) {
            return ItemStack.isSameItem((ItemStack)maidItem, (ItemStack)preItem);
        }
        return ItemStack.matches((ItemStack)maidItem, (ItemStack)preItem);
    }

    public PlayState predicateSwing(AnimationEvent<GeckoMaidEntity<?>> event) {
        IMaid maid = event.getAnimatableEntity().getMaid();
        if (maid == null) {
            return PlayState.STOP;
        }
        if (maid.asEntity().swinging && !maid.asEntity().isSleeping()) {
            String name;
            ConditionalSwing conditionalSwing;
            if (maid.asEntity().swingTime == 0) {
                AnimationManager.playAnimation(event, "empty", ILoopType.EDefaultLoopTypes.PLAY_ONCE);
            }
            ResourceLocation id = event.getAnimatableEntity().getAnimationFileLocation();
            ConditionalSwing conditionalSwing2 = conditionalSwing = maid.asEntity().swingingArm == InteractionHand.MAIN_HAND ? ConditionManager.getSwingMainhand(id) : ConditionManager.getSwingOffhand(id);
            if (conditionalSwing != null && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{name = conditionalSwing.doTest(maid, maid.asEntity().swingingArm)})) {
                return AnimationManager.playAnimation(event, name, ILoopType.EDefaultLoopTypes.PLAY_ONCE);
            }
            String defaultSwing = maid.asEntity().swingingArm == InteractionHand.MAIN_HAND ? "swing_hand" : "swing_offhand";
            return AnimationManager.playAnimation(event, defaultSwing, ILoopType.EDefaultLoopTypes.PLAY_ONCE);
        }
        return PlayState.CONTINUE;
    }

    public PlayState predicateUse(AnimationEvent<GeckoMaidEntity<?>> event) {
        IMaid maid = event.getAnimatableEntity().getMaid();
        if (maid == null) {
            return PlayState.STOP;
        }
        if (maid.asEntity().isUsingItem() && !maid.asEntity().isSleeping()) {
            String name;
            if (maid.asEntity().getTicksUsingItem() == 1) {
                AnimationManager.playAnimation(event, "empty", ILoopType.EDefaultLoopTypes.PLAY_ONCE);
            }
            if (maid.asEntity().getUsedItemHand() == InteractionHand.MAIN_HAND) {
                String name2;
                ResourceLocation id = event.getAnimatableEntity().getAnimationFileLocation();
                ConditionalUse conditionalUse = ConditionManager.getUseMainhand(id);
                if (conditionalUse != null && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{name2 = conditionalUse.doTest(maid, InteractionHand.MAIN_HAND)})) {
                    return AnimationManager.playAnimation(event, name2, ILoopType.EDefaultLoopTypes.LOOP);
                }
                return AnimationManager.playAnimation(event, "use_mainhand", ILoopType.EDefaultLoopTypes.LOOP);
            }
            ResourceLocation id = event.getAnimatableEntity().getAnimationFileLocation();
            ConditionalUse conditionalUse = ConditionManager.getUseOffhand(id);
            if (conditionalUse != null && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{name = conditionalUse.doTest(maid, InteractionHand.OFF_HAND)})) {
                return AnimationManager.playAnimation(event, name, ILoopType.EDefaultLoopTypes.LOOP);
            }
            return AnimationManager.playAnimation(event, "use_offhand", ILoopType.EDefaultLoopTypes.LOOP);
        }
        return PlayState.STOP;
    }

    public PlayState predicateMisc(AnimationEvent<GeckoMaidEntity<?>> event) {
        EntityMaid entityMaid;
        IMaid maid = event.getAnimatableEntity().getMaid();
        if (maid == null) {
            return PlayState.STOP;
        }
        if (maid instanceof EntityMaid && (entityMaid = (EntityMaid)maid).getVehicle() instanceof EntitySit) {
            MaidGameRecordManager manager = entityMaid.getGameRecordManager();
            if (manager.isWin()) {
                return AnimationManager.playAnimation(event, "game_win", ILoopType.EDefaultLoopTypes.LOOP);
            }
            if (manager.isLost()) {
                return AnimationManager.playAnimation(event, "game_lost", ILoopType.EDefaultLoopTypes.LOOP);
            }
        }
        if (maid.isBegging()) {
            return AnimationManager.playAnimation(event, "beg", ILoopType.EDefaultLoopTypes.LOOP);
        }
        return PlayState.STOP;
    }

    public <T extends Mob> PlayState predicateArmor(AnimationEvent<GeckoMaidEntity<T>> event, EquipmentSlot slot) {
        IMaid maid = event.getAnimatableEntity().getMaid();
        if (maid == null) {
            return PlayState.STOP;
        }
        ItemStack itemBySlot = maid.asEntity().getItemBySlot(slot);
        if (itemBySlot.isEmpty()) {
            return PlayState.STOP;
        }
        ResourceLocation id = event.getAnimatableEntity().getAnimationFileLocation();
        ConditionArmor conditionArmor = ConditionManager.getArmor(id);
        if (conditionArmor != null) {
            String name = conditionArmor.doTest(maid, slot);
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{name})) {
                return AnimationManager.playAnimation(event, name, ILoopType.EDefaultLoopTypes.LOOP);
            }
        }
        ResourceLocation animation = event.getAnimatableEntity().getAnimationFileLocation();
        String defaultName = slot.getName() + ":default";
        if (GeckoLibCache.getInstance().getAnimations().get(animation).animations().containsKey(defaultName)) {
            return AnimationManager.playAnimation(event, defaultName, ILoopType.EDefaultLoopTypes.LOOP);
        }
        return PlayState.STOP;
    }

    @Nullable
    public PlayState getVehicleAnimation(AnimationEvent<GeckoMaidEntity<?>> event) {
        String name;
        ConditionalChair conditionalChair;
        Mob mob = event.getAnimatableEntity().getMaid().asEntity();
        if (mob == null) {
            return null;
        }
        Entity vehicle = mob.getVehicle();
        if (vehicle == null || !vehicle.isAlive()) {
            return null;
        }
        ResourceLocation id = event.getAnimatableEntity().getAnimationFileLocation();
        if (vehicle instanceof EntityChair && (conditionalChair = ConditionManager.getChair(id)) != null && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{name = conditionalChair.doTest(mob)})) {
            return AnimationManager.playAnimation(event, name, ILoopType.EDefaultLoopTypes.LOOP);
        }
        ConditionalVehicle vehicleCondition = ConditionManager.getVehicle(id);
        if (vehicleCondition != null && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{name = vehicleCondition.doTest(mob)})) {
            return AnimationManager.playAnimation(event, name, ILoopType.EDefaultLoopTypes.LOOP);
        }
        return null;
    }

    public PlayState predicatePassengerAnimation(AnimationEvent<GeckoMaidEntity<?>> event) {
        String name;
        Mob mob = event.getAnimatableEntity().getMaid().asEntity();
        if (mob == null) {
            return PlayState.STOP;
        }
        Entity passenger = mob.getFirstPassenger();
        if (passenger == null || !passenger.isAlive()) {
            return PlayState.STOP;
        }
        ResourceLocation id = event.getAnimatableEntity().getAnimationFileLocation();
        ConditionalPassenger conditionalPassenger = ConditionManager.getPassenger(id);
        if (conditionalPassenger != null && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{name = conditionalPassenger.doTest(mob)})) {
            return AnimationManager.playAnimation(event, name, ILoopType.EDefaultLoopTypes.LOOP);
        }
        return PlayState.STOP;
    }

    private boolean checkSwingAndUse(IMaid maid, InteractionHand hand) {
        if (maid.asEntity().swinging && maid.asEntity().swingingArm == hand) {
            return false;
        }
        return !maid.asEntity().isUsingItem() || maid.asEntity().getUsedItemHand() != hand;
    }
}

