/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.animation.gecko.molang;

import com.github.tartaricacid.touhoulittlemaid.client.animation.gecko.molang.functions.BonePosition;
import com.github.tartaricacid.touhoulittlemaid.client.animation.gecko.molang.functions.BoneRotation;
import com.github.tartaricacid.touhoulittlemaid.client.animation.gecko.molang.functions.BoneScale;
import com.github.tartaricacid.touhoulittlemaid.client.animation.gecko.molang.functions.EffectLevel;
import com.github.tartaricacid.touhoulittlemaid.client.animation.gecko.molang.functions.EquippedEnchantmentLevel;
import com.github.tartaricacid.touhoulittlemaid.client.animation.gecko.molang.functions.ModVersion;
import com.github.tartaricacid.touhoulittlemaid.client.animation.gecko.molang.functions.RelativeBlockName;
import com.github.tartaricacid.touhoulittlemaid.client.animation.gecko.molang.variable.LadderFacingVariable;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.event.predicate.AnimationEvent;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.molang.binding.ContextBinding;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.molang.builtin.query.EmptyFunction;
import com.github.tartaricacid.touhoulittlemaid.util.EquipmentUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.levelgen.Heightmap;
import net.neoforged.neoforge.common.NeoForgeMod;

public class YSMBinding
extends ContextBinding {
    public static final YSMBinding INSTANCE = new YSMBinding();

    private YSMBinding() {
        this.function("mod_version", new ModVersion());
        this.function("equipped_enchantment_level", new EquippedEnchantmentLevel());
        this.function("effect_level", new EffectLevel());
        this.function("relative_block_name", new RelativeBlockName());
        this.function("bone_rot", new BoneRotation());
        this.function("bone_pos", new BonePosition());
        this.function("bone_scale", new BoneScale());
        this.var("head_yaw", ctx -> Float.valueOf(ctx.data().netHeadYaw));
        this.var("head_pitch", ctx -> Float.valueOf(ctx.data().headPitch));
        this.var("weather", ctx -> YSMBinding.getWeather(ctx.level()));
        this.var("dimension_name", ctx -> ctx.level().dimension().location().toString());
        this.var("fps", ctx -> Minecraft.getInstance().getFps());
        this.entityVar("is_passenger", ctx -> ((Entity)ctx.entity()).isPassenger());
        this.entityVar("is_sleep", ctx -> ((Entity)ctx.entity()).getPose() == Pose.SLEEPING);
        this.entityVar("is_sneak", ctx -> ((Entity)ctx.entity()).onGround() && ((Entity)ctx.entity()).getPose() == Pose.CROUCHING);
        this.entityVar("is_open_air", ctx -> YSMBinding.isOpenAir((Entity)ctx.entity()));
        this.entityVar("eye_in_water", ctx -> ((Entity)ctx.entity()).isUnderWater());
        this.entityVar("frozen_ticks", ctx -> ((Entity)ctx.entity()).getTicksFrozen());
        this.entityVar("air_supply", ctx -> ((Entity)ctx.entity()).getAirSupply());
        this.livingEntityVar("has_helmet", ctx -> YSMBinding.getSlotValue((LivingEntity)ctx.entity(), EquipmentSlot.HEAD));
        this.livingEntityVar("has_chest_plate", ctx -> YSMBinding.getSlotValue((LivingEntity)ctx.entity(), EquipmentSlot.CHEST));
        this.livingEntityVar("has_leggings", ctx -> YSMBinding.getSlotValue((LivingEntity)ctx.entity(), EquipmentSlot.LEGS));
        this.livingEntityVar("has_boots", ctx -> YSMBinding.getSlotValue((LivingEntity)ctx.entity(), EquipmentSlot.FEET));
        this.livingEntityVar("has_mainhand", ctx -> YSMBinding.getSlotValue((LivingEntity)ctx.entity(), EquipmentSlot.MAINHAND));
        this.livingEntityVar("has_offhand", ctx -> YSMBinding.getSlotValue((LivingEntity)ctx.entity(), EquipmentSlot.OFFHAND));
        this.livingEntityVar("has_elytra", ctx -> !EquipmentUtil.getEquippedElytraItem((LivingEntity)ctx.entity()).isEmpty());
        this.livingEntityVar("is_riptide", ctx -> ((LivingEntity)ctx.entity()).isAutoSpinAttack());
        this.livingEntityVar("armor_value", ctx -> ((LivingEntity)ctx.entity()).getArmorValue());
        this.livingEntityVar("hurt_time", ctx -> ((LivingEntity)ctx.entity()).hurtTime);
        this.livingEntityVar("is_close_eyes", ctx -> YSMBinding.getEyeCloseState(ctx.animationEvent(), (LivingEntity)ctx.entity()));
        this.livingEntityVar("on_ladder", ctx -> ((LivingEntity)ctx.entity()).onClimbable());
        this.livingEntityVar("ladder_facing", new LadderFacingVariable());
        this.livingEntityVar("arrow_count", ctx -> ((LivingEntity)ctx.entity()).getArrowCount());
        this.livingEntityVar("stinger_count", ctx -> ((LivingEntity)ctx.entity()).getStingerCount());
        this.livingEntityVar("attack_damage", ctx -> ((LivingEntity)ctx.entity()).getAttributeValue(Attributes.ATTACK_DAMAGE));
        this.livingEntityVar("attack_speed", ctx -> ((LivingEntity)ctx.entity()).getAttributeValue(Attributes.ATTACK_SPEED));
        this.livingEntityVar("attack_knockback", ctx -> ((LivingEntity)ctx.entity()).getAttributeValue(Attributes.ATTACK_KNOCKBACK));
        this.livingEntityVar("movement_speed", ctx -> ((LivingEntity)ctx.entity()).getAttributeValue(Attributes.MOVEMENT_SPEED));
        this.livingEntityVar("knockback_resistance", ctx -> ((LivingEntity)ctx.entity()).getAttributeValue(Attributes.KNOCKBACK_RESISTANCE));
        this.livingEntityVar("luck", ctx -> ((LivingEntity)ctx.entity()).getAttributeValue(Attributes.LUCK));
        this.livingEntityVar("block_reach", ctx -> ((LivingEntity)ctx.entity()).getAttributeValue(Attributes.BLOCK_INTERACTION_RANGE));
        this.livingEntityVar("entity_reach", ctx -> ((LivingEntity)ctx.entity()).getAttributeValue(Attributes.ENTITY_INTERACTION_RANGE));
        this.livingEntityVar("swim_speed", ctx -> ((LivingEntity)ctx.entity()).getAttributeValue(NeoForgeMod.SWIM_SPEED));
        this.livingEntityVar("entity_gravity", ctx -> ((LivingEntity)ctx.entity()).getAttributeValue(Attributes.GRAVITY));
        this.livingEntityVar("step_height_addition", ctx -> ((LivingEntity)ctx.entity()).getAttributeValue(Attributes.STEP_HEIGHT) - 0.6);
        this.livingEntityVar("nametag_distance", ctx -> ((LivingEntity)ctx.entity()).getAttributeValue(NeoForgeMod.NAMETAG_DISTANCE));
        this.function("dump_equipped_item", new EmptyFunction());
        this.function("dump_relative_block", new EmptyFunction());
        this.function("bone_pivot_abs", new EmptyFunction());
        this.var("dump_mods", ctx -> 0);
        this.var("texture_name", ctx -> "");
        this.var("elytra_rot_x", ctx -> 0);
        this.var("elytra_rot_y", ctx -> 0);
        this.var("elytra_rot_z", ctx -> 0);
        this.entityVar("dump_effects", ctx -> 0);
        this.entityVar("dump_biome", ctx -> 0);
        this.entityVar("biome_category", ctx -> 0);
        this.livingEntityVar("rendering_in_inventory", ctx -> false);
        this.maidEntityVar("food_level", ctx -> 20);
        this.var("first_person_mod_hide", ctx -> false);
        this.var("has_left_shoulder_parrot", ctx -> false);
        this.var("has_right_shoulder_parrot", ctx -> false);
        this.var("left_shoulder_parrot_variant", ctx -> 0);
        this.var("right_shoulder_parrot_variant", ctx -> 0);
    }

    private static boolean getEyeCloseState(AnimationEvent<?> animationEvent, LivingEntity player) {
        double remainder = (animationEvent.getAnimationTick() + (double)(Math.abs(player.getUUID().getLeastSignificantBits()) % 10L)) % 90.0;
        boolean isBlinkTime = 85.0 < remainder && remainder < 90.0;
        return player.isSleeping() || isBlinkTime;
    }

    private static boolean getSlotValue(LivingEntity entity, EquipmentSlot slot) {
        return !EquipmentUtil.getEquippedItem(entity, slot).isEmpty();
    }

    private static int getWeather(ClientLevel world) {
        if (world.isThundering()) {
            return 2;
        }
        if (world.isRaining()) {
            return 1;
        }
        return 0;
    }

    private static boolean isOpenAir(Entity entity) {
        BlockPos blockpos = entity.blockPosition();
        if (!entity.level.canSeeSky(blockpos)) {
            return false;
        }
        return entity.level.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, blockpos).getY() <= blockpos.getY();
    }
}

