/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.animation.special;

import com.github.tartaricacid.touhoulittlemaid.api.animation.ICustomAnimation;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Mob;

public class SwimAnimation
implements ICustomAnimation<Mob> {
    @Override
    public void setupRotations(Mob mob, PoseStack poseStack, float ageInTicks, float rotationYaw, float partialTicks) {
        boolean inSwimFluidType = mob.isInFluidType((type, height) -> mob.canSwimInFluidType(type));
        boolean inSwim = mob.isInWater() || inSwimFluidType;
        float xRot = 90.0f + (inSwim ? mob.getXRot() : 0.0f);
        float xRotLerp = Mth.lerp((float)mob.getSwimAmount(partialTicks), (float)0.0f, (float)(-xRot));
        poseStack.mulPose(Axis.XP.rotationDegrees(xRotLerp));
        if (mob.isVisuallySwimming()) {
            poseStack.translate(0.0f, -1.0f, 0.3f);
        }
    }
}

