/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.gui.entity.detail;

import com.github.tartaricacid.touhoulittlemaid.client.gui.entity.cache.CacheIconManager;
import com.github.tartaricacid.touhoulittlemaid.client.gui.entity.detail.AbstractModelDetailsGui;
import com.github.tartaricacid.touhoulittlemaid.client.gui.widget.button.ModelDetailsButton;
import com.github.tartaricacid.touhoulittlemaid.client.resource.pojo.ChairModelInfo;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntityChair;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitEntities;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;

public class ChairModelDetailsGui
extends AbstractModelDetailsGui<EntityChair, ChairModelInfo> {
    private EntityMaid maid;
    private boolean showPassenger = false;

    public ChairModelDetailsGui(EntityChair sourceEntity, ChairModelInfo modelInfo) {
        super(sourceEntity, (EntityChair)InitEntities.CHAIR.get().create(sourceEntity.level()), modelInfo);
        ((EntityChair)this.guiEntity).setModelId(modelInfo.getModelId().toString());
        if (Minecraft.getInstance().level != null) {
            this.maid = (EntityMaid)InitEntities.MAID.get().create((Level)Minecraft.getInstance().level);
            if (this.maid != null) {
                this.maid.setModelId("authors_and_credits:wine_fox_maid");
            }
        }
    }

    @Override
    protected void applyReturnButtonLogic() {
        CacheIconManager.openChairModelGui((EntityChair)this.sourceEntity);
    }

    @Override
    protected void initSideButton() {
        ModelDetailsButton showPassengerButton = new ModelDetailsButton(2, 17, "gui.touhou_little_maid.skin_details.show_passenger", this::applyShowPassengerLogic);
        this.addRenderableWidget((GuiEventListener)showPassengerButton);
    }

    public void tick() {
        ++((EntityChair)this.guiEntity).tickCount;
        if (this.maid != null) {
            ++this.maid.tickCount;
        }
    }

    @Override
    protected void renderExtraEntity(EntityRenderDispatcher manager, PoseStack matrix, MultiBufferSource.BufferSource bufferIn) {
        if (this.showPassenger) {
            manager.render((Entity)this.maid, 0.0, -0.375 + (double)((ChairModelInfo)this.modelInfo).getMountedYOffset(), 0.0, 0.0f, 1.0f, matrix, (MultiBufferSource)bufferIn, 0xF000F0);
        }
    }

    private void applyShowPassengerLogic(boolean isStateTriggered) {
        this.showPassenger = isStateTriggered;
        if (isStateTriggered && this.maid != null) {
            this.maid.startRiding((Entity)this.guiEntity, true);
        } else {
            ((EntityChair)this.guiEntity).ejectPassengers();
        }
    }
}

