/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.gui.entity.maid.ai;

import com.github.tartaricacid.touhoulittlemaid.client.gui.widget.button.FlatColorButton;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.network.message.GetMaidAIDataPackage;
import com.github.tartaricacid.touhoulittlemaid.network.message.SendUserChatPackage;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.language.LanguageInfo;
import net.minecraft.client.resources.language.LanguageManager;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.neoforge.network.PacketDistributor;
import org.apache.commons.lang3.StringUtils;

public class AIChatScreen
extends Screen {
    public static final Map<String, List<String>> CLIENT_CHAT_SITES = Maps.newLinkedHashMap();
    public static final Map<String, List<String>> CLIENT_TTS_SITES = Maps.newLinkedHashMap();
    private final EntityMaid maid;
    private EditBox input;
    private FlatColorButton configButton;
    private int tickCounter = 0;

    public AIChatScreen(EntityMaid maid) {
        super((Component)Component.literal((String)"Maid AI Chat Screen"));
        this.maid = maid;
    }

    protected void init() {
        int posX = this.width / 2;
        int posY = this.height / 2;
        this.input = new EditBox(this.getMinecraft().fontFilterFishy, posX - 165, posY + 64, 300, 20, (Component)Component.translatable((String)"chat.editBox"));
        this.input.setMaxLength(128);
        this.input.setBordered(false);
        this.input.setValue("");
        this.input.setCanLoseFocus(false);
        this.addWidget((GuiEventListener)this.input);
        this.setInitialFocus((GuiEventListener)this.input);
        this.configButton = new FlatColorButton(posX + 142, posY + 58, 20, 20, (Component)Component.literal((String)"\u270e"), b -> PacketDistributor.sendToServer((CustomPacketPayload)new GetMaidAIDataPackage(this.maid.getId()), (CustomPacketPayload[])new CustomPacketPayload[0])).setTooltips("ai.touhou_little_maid.chat.config.tip");
        this.addRenderableWidget((GuiEventListener)this.configButton);
    }

    public void resize(Minecraft mc, int pWidth, int pHeight) {
        String chatText = this.input.getValue();
        super.resize(mc, pWidth, pHeight);
        this.input.setValue(chatText);
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        int xOffset = 5;
        int yOffset = 6;
        graphics.fill(this.input.getX() - xOffset, this.input.getY() - yOffset, this.input.getX() + this.input.getInnerWidth() + xOffset, this.input.getY() + this.input.getHeight() - yOffset, -1627389952);
        this.input.render(graphics, mouseX, mouseY, partialTicks);
        if (StringUtils.isEmpty((CharSequence)this.input.getValue())) {
            MutableComponent text = Component.translatable((String)"ai.touhou_little_maid.chat.input.tip").withStyle(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC});
            int xPos = this.input.getX() + this.input.getInnerWidth() / 2 - xOffset;
            graphics.drawCenteredString(this.font, (Component)text, xPos, this.input.getY(), 0xFFFFFF);
        }
        for (Renderable renderable : this.renderables) {
            renderable.render(graphics, mouseX, mouseY, partialTicks);
        }
        this.configButton.renderToolTip(graphics, this, mouseX, mouseY);
    }

    public void tick() {
        ++this.tickCounter;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.input.mouseClicked(mouseX, mouseY, button)) {
            this.setFocused((GuiEventListener)this.input);
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean charTyped(char pCodePoint, int pModifiers) {
        if (this.tickCounter < 5) {
            return false;
        }
        return super.charTyped(pCodePoint, pModifiers);
    }

    protected void insertText(String text, boolean overwrite) {
        if (overwrite) {
            this.input.setValue(text);
        } else {
            this.input.insertText(text);
        }
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 257) {
            this.sendDoneMessage();
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean isPauseScreen() {
        return false;
    }

    private void sendDoneMessage() {
        String value = this.input.getValue();
        LocalPlayer player = this.getMinecraft().player;
        if (StringUtils.isNotBlank((CharSequence)value) && player != null) {
            LanguageManager languageManager = Minecraft.getInstance().getLanguageManager();
            LanguageInfo info = languageManager.getLanguage(languageManager.getSelected());
            String language = info != null ? info.toComponent().getString() : "English (US)";
            PacketDistributor.sendToServer((CustomPacketPayload)new SendUserChatPackage(this.maid.getId(), value, language), (CustomPacketPayload[])new CustomPacketPayload[0]);
            String name = player.getScoreboardName();
            String format = String.format("<%s> %s", name, value);
            player.sendSystemMessage((Component)Component.literal((String)format).withStyle(ChatFormatting.GRAY));
        }
        this.onClose();
    }
}

