/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.gui.entity.maid.backpack;

import com.github.tartaricacid.touhoulittlemaid.client.gui.entity.maid.AbstractMaidContainerGui;
import com.github.tartaricacid.touhoulittlemaid.client.gui.entity.maid.backpack.IBackpackContainerScreen;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.inventory.container.backpack.TankBackpackContainer;
import com.github.tartaricacid.touhoulittlemaid.util.MaidFluidRender;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import org.anti_ad.mc.ipn.api.IPNButton;
import org.anti_ad.mc.ipn.api.IPNGuiHint;
import org.anti_ad.mc.ipn.api.IPNGuiHints;
import org.anti_ad.mc.ipn.api.IPNPlayerSideOnly;

@IPNPlayerSideOnly
@IPNGuiHints(value={@IPNGuiHint(button=IPNButton.SORT, horizontalOffset=-36, bottom=-12), @IPNGuiHint(button=IPNButton.SORT_COLUMNS, horizontalOffset=-24, bottom=-24), @IPNGuiHint(button=IPNButton.SORT_ROWS, horizontalOffset=-12, bottom=-36), @IPNGuiHint(button=IPNButton.SHOW_EDITOR, horizontalOffset=-5), @IPNGuiHint(button=IPNButton.SETTINGS, horizontalOffset=-5)})
public class TankBackpackContainerScreen
extends AbstractMaidContainerGui<TankBackpackContainer>
implements IBackpackContainerScreen {
    private static final ResourceLocation BACKPACK = ResourceLocation.fromNamespaceAndPath((String)"touhou_little_maid", (String)"textures/gui/maid_tank.png");
    private final EntityMaid maid;

    public TankBackpackContainerScreen(TankBackpackContainer container, Inventory inv, Component titleIn) {
        super(container, inv, titleIn);
        this.imageHeight = 256;
        this.imageWidth = 256;
        this.maid = ((TankBackpackContainer)this.menu).getMaid();
    }

    @Override
    protected void renderBg(GuiGraphics graphics, float partialTicks, int x, int y) {
        boolean yInRange;
        super.renderBg(graphics, partialTicks, x, y);
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)BACKPACK);
        graphics.blit(BACKPACK, this.leftPos + 85, this.topPos + 36, 0, 0, 165, 128);
        RenderSystem.enableBlend();
        MaidFluidRender.drawFluid(graphics, this.leftPos + 200, this.topPos + 108, 29, 50, this.maid.getBackpackFluid(), ((TankBackpackContainer)this.menu).getFluidCount(), 10000);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
        graphics.blit(BACKPACK, this.leftPos + 197, this.topPos + 104, 165, 0, 34, 50);
        boolean xInRange = this.leftPos + 196 <= x && x <= this.leftPos + 196 + 29;
        boolean bl = yInRange = this.topPos + 108 <= y && y <= this.topPos + 108 + 50;
        if (xInRange && yInRange) {
            MutableComponent fluidInfo = Component.translatable((String)"tooltips.touhou_little_maid.tank_backpack.fluid", (Object[])new Object[]{MaidFluidRender.getFluidName(this.maid.getBackpackFluid(), ((TankBackpackContainer)this.menu).getFluidCount()), ((TankBackpackContainer)this.menu).getFluidCount()}).withStyle(ChatFormatting.GRAY);
            MutableComponent capacityInfo = Component.translatable((String)"tooltips.touhou_little_maid.tank_backpack.capacity", (Object[])new Object[]{10000}).withStyle(ChatFormatting.GRAY);
            graphics.renderComponentTooltip(this.font, (List)Lists.newArrayList((Object[])new Component[]{fluidInfo, capacityInfo}), x, y);
        }
    }
}

