/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.gui.entity.maid.task;

import com.github.tartaricacid.touhoulittlemaid.client.gui.entity.maid.task.MaidTaskConfigGui;
import com.github.tartaricacid.touhoulittlemaid.client.gui.widget.button.MonsterListButton;
import com.github.tartaricacid.touhoulittlemaid.client.gui.widget.button.TouhouImageButton;
import com.github.tartaricacid.touhoulittlemaid.entity.data.inner.AttackListData;
import com.github.tartaricacid.touhoulittlemaid.entity.misc.MonsterType;
import com.github.tartaricacid.touhoulittlemaid.init.InitTaskData;
import com.github.tartaricacid.touhoulittlemaid.inventory.container.task.TaskConfigContainer;
import com.github.tartaricacid.touhoulittlemaid.network.message.SetAttackListPackage;
import com.github.tartaricacid.touhoulittlemaid.util.ResourceLocationUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Inventory;
import net.neoforged.neoforge.network.PacketDistributor;
import org.anti_ad.mc.ipn.api.IPNButton;
import org.anti_ad.mc.ipn.api.IPNGuiHint;
import org.anti_ad.mc.ipn.api.IPNGuiHints;
import org.anti_ad.mc.ipn.api.IPNPlayerSideOnly;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;

@IPNPlayerSideOnly
@IPNGuiHints(value={@IPNGuiHint(button=IPNButton.SORT, horizontalOffset=-36, bottom=-12), @IPNGuiHint(button=IPNButton.SORT_COLUMNS, horizontalOffset=-24, bottom=-24), @IPNGuiHint(button=IPNButton.SORT_ROWS, horizontalOffset=-12, bottom=-36), @IPNGuiHint(button=IPNButton.SHOW_EDITOR, horizontalOffset=-5), @IPNGuiHint(button=IPNButton.SETTINGS, horizontalOffset=-5)})
public class AttackTaskConfigGui
extends MaidTaskConfigGui<TaskConfigContainer> {
    private static final ResourceLocation BG = ResourceLocation.fromNamespaceAndPath((String)"touhou_little_maid", (String)"textures/gui/attack_task_config.png");
    private final Map<ResourceLocation, MonsterType> attackGroups = Objects.requireNonNullElse(this.getMaid().getData(InitTaskData.ATTACK_LIST), AttackListData.empty()).attackGroups();
    private final List<ResourceLocation> attackGroupsKey = Lists.newArrayList();
    private EditBox inputField;
    private int page = 0;

    public AttackTaskConfigGui(TaskConfigContainer screenContainer, Inventory inv, Component titleIn) {
        super(screenContainer, inv, titleIn);
        this.sortKey();
    }

    private void sortKey() {
        this.attackGroupsKey.clear();
        ArrayList hostile = Lists.newArrayList();
        ArrayList neutral = Lists.newArrayList();
        ArrayList friendly = Lists.newArrayList();
        for (ResourceLocation id : this.attackGroups.keySet()) {
            if (this.attackGroups.get(id) == MonsterType.HOSTILE) {
                hostile.add(id);
            }
            if (this.attackGroups.get(id) == MonsterType.NEUTRAL) {
                neutral.add(id);
            }
            if (this.attackGroups.get(id) != MonsterType.FRIENDLY) continue;
            friendly.add(id);
        }
        this.attackGroupsKey.addAll(hostile);
        this.attackGroupsKey.addAll(neutral);
        this.attackGroupsKey.addAll(friendly);
        this.page = Mth.clamp((int)this.page, (int)0, (int)((this.attackGroupsKey.size() - 1) / 7));
    }

    @Override
    protected void initAdditionWidgets() {
        int startLeft = this.leftPos + 87;
        int startTop = this.topPos + 36;
        this.inputField = new EditBox(this.font, startLeft, startTop, 117, 16, (Component)Component.literal((String)"Monster List"));
        this.inputField.setMaxLength(256);
        this.addWidget((GuiEventListener)this.inputField);
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"gui.touhou_little_maid.monster_type.add"), b -> this.addMonsterType()).pos(startLeft + 119, startTop - 1).size(44, 18).build());
        this.addRenderableWidget((GuiEventListener)new TouhouImageButton(startLeft + 121, startTop + 20, 5, 9, 0, 176, 9, BG, b -> {
            --this.page;
            this.page = Mth.clamp((int)this.page, (int)0, (int)((this.attackGroupsKey.size() - 1) / 7));
            this.init();
        }));
        this.addRenderableWidget((GuiEventListener)new TouhouImageButton(startLeft + 156, startTop + 20, 5, 9, 5, 176, 9, BG, b -> {
            ++this.page;
            this.page = Mth.clamp((int)this.page, (int)0, (int)((this.attackGroupsKey.size() - 1) / 7));
            this.init();
        }));
        for (int i = 0; i < 7; ++i) {
            int index = this.page * 7 + i;
            if (index >= this.attackGroupsKey.size()) {
                return;
            }
            ResourceLocation id = this.attackGroupsKey.get(index);
            EntityType type = (EntityType)BuiltInRegistries.ENTITY_TYPE.get(id);
            Component name = type.getDescription();
            int yOffset = startTop + 31 + 13 * i;
            this.addRenderableWidget((GuiEventListener)new MonsterListButton(name, startLeft - 1, yOffset, id, this));
        }
    }

    private void addMonsterType() {
        String value = this.inputField.getValue();
        if (StringUtils.isBlank((CharSequence)value)) {
            return;
        }
        if (!ResourceLocationUtil.isValidResourceLocation(value)) {
            return;
        }
        ResourceLocation id = ResourceLocation.parse((String)value);
        if (BuiltInRegistries.ENTITY_TYPE.containsKey(id)) {
            this.attackGroups.put(id, MonsterType.NEUTRAL);
            this.sortKey();
            super.init();
        }
    }

    public void removeMonsterType(ResourceLocation id) {
        this.attackGroups.remove(id);
        this.sortKey();
        super.init();
    }

    public void resize(Minecraft minecraft, int width, int height) {
        String value = this.inputField.getValue();
        super.resize(minecraft, width, height);
        this.inputField.setValue(value);
    }

    @Override
    protected void renderAddition(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.inputField.render(graphics, mouseX, mouseY, partialTicks);
        MutableComponent pageText = Component.literal((String)String.format("%d/%d", this.page + 1, (this.attackGroupsKey.size() - 1) / 7 + 1));
        graphics.drawCenteredString(this.font, (Component)pageText, this.leftPos + 228, this.topPos + 57, 0xFFFFFF);
        graphics.drawCenteredString(this.font, (Component)Component.translatable((String)"gui.touhou_little_maid.monster_type.title"), this.leftPos + 147, this.topPos + 57, 0xFFFFFF);
    }

    @Override
    protected void renderBg(GuiGraphics graphics, float partialTicks, int x, int y) {
        super.renderBg(graphics, partialTicks, x, y);
        graphics.blit(BG, this.leftPos + 80, this.topPos + 28, 0, 0, this.imageWidth, 137);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256 && this.getMinecraft().player != null) {
            this.getMinecraft().player.closeContainer();
        }
        return this.inputField.keyPressed(keyCode, scanCode, modifiers) || this.inputField.canConsumeInput() || super.keyPressed(keyCode, scanCode, modifiers);
    }

    @Override
    public void onClose() {
        PacketDistributor.sendToServer((CustomPacketPayload)new SetAttackListPackage(this.getMaid().getId(), this.attackGroups), (CustomPacketPayload[])new CustomPacketPayload[0]);
        super.onClose();
    }

    public Map<ResourceLocation, MonsterType> getAttackGroups() {
        return this.attackGroups;
    }
}

