/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.gui.entity.model;

import com.github.tartaricacid.touhoulittlemaid.client.resource.pojo.CustomModelPack;
import com.github.tartaricacid.touhoulittlemaid.client.resource.pojo.IModelInfo;
import java.util.List;
import net.minecraft.util.Mth;

public class SkinGuiNumber<T extends IModelInfo> {
    private static final int PACK_INTERVAL = 7;
    private static final int MODEL_PER_ROW = 11;
    private static final int MODEL_TOTAL_ROW = 5;
    private final List<CustomModelPack<T>> modelPackList;

    public SkinGuiNumber(List<CustomModelPack<T>> modelPackList) {
        this.modelPackList = modelPackList;
    }

    public int getPackSize() {
        return this.modelPackList.size();
    }

    public int getModelSize(int packIndex) {
        packIndex = Mth.clamp((int)packIndex, (int)0, (int)(this.modelPackList.size() - 1));
        return this.modelPackList.get(packIndex).getModelList().size();
    }

    public int getPageSize() {
        return (this.modelPackList.size() - 1) / 7 + 1;
    }

    public int getTabIndex(int packIndex) {
        return packIndex % 7;
    }

    public int getTabSize(int packIndex) {
        if (packIndex < (this.getPageSize() - 1) * 7) {
            return 7;
        }
        return (this.getPackSize() - 1) % 7 + 1;
    }

    public int tabToPackIndex(int tabIndex, int pageIndex) {
        return Mth.clamp((int)(pageIndex * 7 + tabIndex), (int)0, (int)(this.getPackSize() - 1));
    }

    public int modelFromIndex(int rowIndex) {
        return 11 * rowIndex;
    }

    public int modelToIndex(int packIndex, int rowIndex) {
        return Math.min(11 * (rowIndex + 5), this.getModelSize(packIndex));
    }

    public int getRowSize(int packIndex) {
        int row = (this.getModelSize(packIndex) - 1) / 11 + 1;
        return Math.max(row - 5, 0);
    }

    public boolean canScroll(int packIndex, int rowIndex) {
        int modelSize = this.getModelSize(packIndex) - 11 * rowIndex;
        return modelSize > 55;
    }

    public float getCurrentScroll(int packIndex, int rowIndex) {
        return Mth.clamp((float)((float)((double)rowIndex * (1.0 / (double)((this.getModelSize(packIndex) - 1) / 11 - 4)))), (float)0.0f, (float)1.0f);
    }
}

